package com.rv.home.rv.module.basic;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;

import com.alibaba.fastjson.JSON;
import com.frame.base.bus.LoginSuccessfulEvent;
import com.frame.base.bus.LoginUserInfoEvent;
import com.frame.base.bus.RxBus;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.SPConstance;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.Cookie;
import com.rv.component.utils.LogUtil;
import com.rv.home.R;
import com.rv.home.rv.module.ApiConfig;
import com.ruiwenliu.wrapper.bean.BeanUserInfo;
import com.rv.home.rv.module.ui.login.bean.RegisteredBean;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.utils.SocializeUtils;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created :Auser
 * Date: 2019/5/15.
 * Desc:登录基类
 */

public abstract class BaseLoginActivity<P extends MvpPresenter> extends BaseStatusActivity<P> implements UMAuthListener {
    public ProgressDialog dialog;

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        dialog = new ProgressDialog(this);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        UMShareAPI.get(mActivity).onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        UMShareAPI.get(mActivity).release();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        UMShareAPI.get(mActivity).onSaveInstanceState(outState);
    }

    @Override
    public void onStart(SHARE_MEDIA platform) {
        SocializeUtils.safeShowDialog(dialog);
    }

    @Override
    public void onError(SHARE_MEDIA platform, int action, Throwable t) {
        SocializeUtils.safeCloseDialog(dialog);
        showToast(mActivity.getString(R.string.rv_login_authorization_failure) + t.getMessage());
    }

    @Override
    public void onCancel(SHARE_MEDIA platform, int action) {
        SocializeUtils.safeCloseDialog(dialog);
//        Toast.makeText(LoginActivity.this, "取消了", Toast.LENGTH_LONG).show();
    }

    public void umLogin(SHARE_MEDIA share_media) {
        UMShareAPI.get(mActivity).getPlatformInfo(mActivity, share_media, this);
    }


    public void setDataUser(BeanUserInfo data) {
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_USERINFO, JSON.toJSONString(data.getData())).commit();
        RxBus.post(new LoginUserInfoEvent());
    }

    /**
     * 第三方登录
     *
     * @param username
     * @param mobilecode
     * @param password
     * @param nickname
     * @param headimgurl
     * @param openid
     * @param type
     */
    public void otherLoginBind(String username, String mobilecode, String password, String nickname, String headimgurl, String openid, int type, int isQQ, String uid) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("username", username);
        map.put("mobilecode", mobilecode);
        map.put("password", password);
        map.put("nickname", nickname);
        map.put("headimgurl", headimgurl);
        map.put("openid", openid);
        map.put("type", type);
        map.put("isQQ", isQQ);
        if (isQQ == 0) {
            map.put("unionid", uid);
        }
        mPresenter.postData(2, ApiConfig.HTTP_URL_OTHER_LOGIN_BIND, RegisteredBean.class, map, true);
    }

    public void processLoginData(RegisteredBean bean) {

        LogUtil.d("登录返回的code为" + bean.getData().getCode());
        RegisteredBean registeredBean = bean;
        Cookie.save(getApplicationContext(), SPConstance.USER_JSON_CODE, registeredBean.getData().getCode());
        Cookie.save(getApplicationContext(), SPConstance.USER_JSON_NAME, registeredBean.getData().getUsername());
        Cookie.save(getApplicationContext(), SPConstance.USER_JSON_HEADERURL, registeredBean.getData().getHeaderurl());
        Cookie.save(getApplicationContext(), SPConstance.USER_JSON_TOKEN, registeredBean.getToken());
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_CODE, registeredBean.getData().getCode()).commit();
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_NAME, registeredBean.getData().getUsername()).commit();
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_HEADERURL, registeredBean.getData().getHeaderurl()).commit();
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_USERID, registeredBean.getData().getUserId()).commit();
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_TOKEN, registeredBean.getToken()).commit();
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_IMUSERID, registeredBean.getData().getImUserId()).commit();
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_IMTOKEN, registeredBean.getData().getImToken()).commit();
        UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_ISCERTIFICATIONSTATUS, registeredBean.getData().getCertificationStatus()).commit();

        Map<String, Object> headMap = new LinkedHashMap<>();
        if (registeredBean.getToken() != null) {
            headMap.put("Authorization", registeredBean.getToken());
            mPresenter.getDataHead(RvFrameConfig.ADMIN_POST, 10, ApiConfig.HTTP_URL_APP_USER_INFO, BeanUserInfo.class, headMap, false);
        }
        OkGoUtil.setToken(registeredBean.getToken());
//        switch (RvFrameConfig.RvFrameInfo.TYPE_LOGIN) {
//            case 1:
//                if ("0".equals(bean.getData().getCertificationStatus())) {   //实名认证状态:0-未认证，1-已认证
//                    ARouter.getInstance().build(Constance.ACTIVITY_URL_IDCARDCERTIFICATION).navigation();
//                } else {
//                    startActivity(CarDetailActivity.getIntent(mActivity, 1));
//                }
//                break;
//            default:
//                finish();
//                break;
//        }

        RxBus.post(new LoginSuccessfulEvent());
        finish();
    }

}
