package com.ruiwenliu.wrapper.weight.refresh;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ruiwenliu.wrapper.R;

public class SimpleLoadView extends LinearLayout implements IFooterWrapper {

    private TextView tvStatus;

    public SimpleLoadView(Context context) {
        this(context, null);
    }

    public SimpleLoadView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SimpleLoadView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
    }

    private void initView() {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.view_load_foot, this, false);
        tvStatus = view.findViewById(R.id.tv_status);
        addView(view);
    }


    @Override
    public View getFooterView() {
        return this;
    }

    @Override
    public void pullUp() {
        tvStatus.setText("加载更多");
    }

    @Override
    public void pullUpReleasable() {
        tvStatus.setText("松手可加载更多");
    }

    @Override
    public void pullUpRelease() {
        tvStatus.setText("正在加载...");
    }

    @Override
    public void pullUpFinish() {

    }
}
