package com.frame.base.manager;

import com.base.utils.Config;
import com.base.utils.tools.android.SPUtil;
import com.frame.base.FrameApp;
import com.frame.base.server.MyFrameService;

/**
 * 框架管理者
 */

public class MyFrameManager {
    private FrameApp frameApp;

    private MyFrameManager() {
        frameApp = FrameApp.getInstance();
    }

    private static MyFrameManager instance;

    public synchronized static MyFrameManager getInstance() {
        if (instance == null) {
            instance = new MyFrameManager();
        }
        return instance;
    }

    /**
     * 设置 本地保存的 屏幕是否常亮 的值
     */
    public void setKeepWake(boolean isKeepWake) {
        SPUtil.setBoolean(frameApp, Config.spGlobalWake, isKeepWake);
        if (isKeepWake) {
            MyFrameService.keepWake();
        } else {
            MyFrameService.wakeRelease();
        }
    }

    /**
     * 取出 本地保存的 屏幕是否常亮 的值
     */
    public boolean isKeepWake() {
        return SPUtil.getBoolean(frameApp, Config.spGlobalWake);

    }

}
