package com.rv.member.presenter;

import android.content.Context;
import android.widget.Toast;

import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.weight.ToastView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.member.bean.MemberListBean;
import com.rv.member.bean.BeanTourOrderPay;
import com.rv.member.bean.MemberOrderBean;
import com.rv.member.bean.MemberOrderPostBodyBean;
import com.rv.member.bean.PayBodyBean;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

public class MemberPresenter extends CommonPresenter {

    public void pay(Context context, IWXAPI api, BeanTourOrderPay data) {
        try {
            PayReq req = new PayReq();
            req.appId = data.getData().getAppid();
            req.partnerId = data.getData().getPartnerid();
            req.prepayId = data.getData().getPrepayid();
            req.nonceStr = data.getData().getNoncestr();
            req.timeStamp = data.getData().getTimestamp();
            req.packageValue = data.getData().getPackageX();
            req.sign = data.getData().getSign();
            req.extData = "app data"; // optional
            api.sendReq(req);
        } catch (Exception e) {
            ToastView.getInstance(context).showToastContent("异常", Toast.LENGTH_SHORT);
        }
    }

    public void createOrder(MemberListBean.MemberCard card, int position) {

        MemberOrderPostBodyBean memberOrderPostBodyBean = new MemberOrderPostBodyBean("", card.getLevel(), card.getId());
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        postBodyData(RvFrameConfig.ADMIN_POST, position, ApiConfig.HTTP_URL_MEMBER_CREATE_ORDER, MemberOrderBean.class, memberOrderPostBodyBean, headMap, true);
    }

    /**
     * 订单支付
     */
    public void orderPay(String orderNo, int payWay, int type) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        postBodyData(RvFrameConfig.VEHICLE_ORDER, 3, ApiConfig.COMMIT_ORDER_PAY, BeanTourOrderPay.class, new PayBodyBean(orderNo, payWay, type), headMap, true);
    }

}
