package com.rv.member.fragment;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.order.OrderDetailActivity;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.member.ConsumeRecordActivity;
import com.rv.member.R;
import com.rv.member.R2;
import com.rv.member.adapter.ConsumeRecordListAdapter;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;

public class UserDetailFragment extends BaseFragment<CommonPresenter> implements SimpleRefreshLayout.OnSimpleRefreshListener, BaseQuickAdapter.RequestLoadMoreListener{


    @BindView(R2.id.refresh)
    SimpleRefreshLayout simpleRefreshLayout;
    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;

    private int mPage = 1;
    private int pageCount;
    private ConsumeRecordListAdapter adapter = null;
    private List<OrderListBean.DataBeanX.DataBean> lists = new ArrayList<>();

    public static UserDetailFragment getInstance() {
        UserDetailFragment fragment = new UserDetailFragment();
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.common_refresh;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        adapter = new ConsumeRecordListAdapter(lists, mClickListener);
        adapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.tv_no_consume_data)));
        adapter.setOnLoadMoreListener(this, recyclerView);
        recyclerView.setAdapter(adapter);
        simpleRefreshLayout.setHeaderView(new SimpleRefreshView(getContext()));
        simpleRefreshLayout.setOnSimpleRefreshListener(this);
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {
        getConsumeRecordData(0);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 1) {   // 下拉刷新数据
            lists.clear();
            simpleRefreshLayout.onRefreshComplete();
        } else if (requestType == 2) {   // 上拉加载更多
            simpleRefreshLayout.onLoadMoreComplete();
        }
        OrderListBean listBean = (OrderListBean) result;
        if (listBean != null && listBean.getData() != null) {
//            pageCount = listBean.getData().getTotalPage();
//            lists.addAll(listBean.getData().getData());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            lists.add(new OrderListBean.DataBeanX.DataBean());
            adapter.notifyDataSetChanged();
        }
    }

    private void getConsumeRecordData(int position) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> bodyMap = new LinkedHashMap<>();
        bodyMap.put("page", mPage);
        bodyMap.put("limit", 10);
//        bodyMap.put("status", "3");
        bodyMap.put("hasMemberRight", 1);
        bodyMap.put("type", 1);
        bodyMap.put("multiStatus", "4,5,6");
        mPresenter.getData(RvFrameConfig.VEHICLE_ORDER, position, ApiConfig.HTTP_URL_ORDER_LIST, OrderListBean.class, bodyMap, headMap, mPage == 1 ? true : false);
    }


    @Override
    public void onRefresh() {
        mPage = 1;
        getConsumeRecordData(1);
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= pageCount) {
            adapter.loadMoreEnd();
        } else {
            mPage += 1;
            getConsumeRecordData(2);
        }
    }

    private ConsumeRecordListAdapter.ConsumeListener mClickListener = new ConsumeRecordListAdapter.ConsumeListener() {
        @Override
        public void click(OrderListBean.DataBeanX.DataBean bean) {
            if (bean != null) {
                startActivity(OrderDetailActivity.getIntent(getContext(), bean));
            }
        }
    };
}
