package com.rv.member.adapter;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.member.R;

import java.util.List;

public class ConsumeRecordListAdapter extends BaseQuickAdapter<OrderListBean.DataBeanX.DataBean, BaseViewHolder> {

    private ConsumeListener mListener;


    public interface ConsumeListener {
        void click(OrderListBean.DataBeanX.DataBean bean);
    }

    public ConsumeRecordListAdapter(List<OrderListBean.DataBeanX.DataBean> dataBeans, ConsumeListener mClickListener) {
        super(R.layout.item_consume_record, dataBeans);
        this.mListener = mClickListener;
    }


    @Override
    protected void convert(BaseViewHolder helper, final OrderListBean.DataBeanX.DataBean bean) {

        ImageView imgCarType = helper.itemView.findViewById(R.id.img_car_type);
        GlideManager.getInstance(mContext).loadImage("https://xxtest.upyuns.com/image/admin/2019-06-27/4.png", imgCarType, 160, 160);

        if (bean != null) {
            if (!TextUtils.isEmpty(bean.getCrtTime())) {
                helper.setText(R.id.tv_consume_time, "下单时间: " + bean.getCrtTime());
                if (bean.getStatusX() == 4) {
                    helper.setText(R.id.tv_state, "待出行");
                } else if (bean.getStatusX() == 5) {
                    helper.setText(R.id.tv_state, "出行中");
                } else if (bean.getStatusX() == 6) {
                    helper.setText(R.id.tv_state, "已完成");
                }
                if (!TextUtils.isEmpty(bean.getName())) {
                    helper.setText(R.id.tv_car_type, bean.getName());
                }
                helper.setText(R.id.tv_price, "¥" + bean.getOrderAmount());

                if (!TextUtils.isEmpty(bean.getPicture())) {
//                    ImageView imgCarType = helper.itemView.findViewById(R.id.img_car_type);
                    GlideManager.getInstance(mContext).loadImage(bean.getPicture(), imgCarType);
                }
            }
            OrderListBean.DataBeanX.DataBean.OrderRentVehicleDetail vehicleDetail = bean.getOrderRentVehicleDetail();
            if (vehicleDetail != null) {
                helper.setText(R.id.tv_location, vehicleDetail.getStart_city_name() + "-" + vehicleDetail.getEnd_city_name());
                helper.setText(R.id.tv_get_info, vehicleDetail.getStart_time() + " " + vehicleDetail.getStart_addr());
                helper.setText(R.id.tv_return_info, vehicleDetail.getEnd_time() + " " + vehicleDetail.getEnd_addr());
                if (vehicleDetail.getFreeDays() > 0) {
                    helper.setText(R.id.tv_member_right, "免费" + vehicleDetail.getFreeDays() + "天");
                } else if (vehicleDetail.getRebate() > 0) {
                    helper.setText(R.id.tv_member_right, ((int) vehicleDetail.getRebate() / 10) + "折");
                }
            }
        }

        helper.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (mListener != null) {
                    mListener.click(bean);
                }
            }
        });
    }
}
