package com.rv.rvmine.traveler;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.login.RegisteredActivity;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;
import com.rv.version.bean.VersionCheckBean;
import com.rv.version.util.UpdateAppUtils;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 设置
 */

public class SettingActivity extends BaseStatusActivity<CommonPresenter> {

    private UpdateAppUtils updateAppUtils;

    @Override
    protected int setLayout() {
        return R.layout.activity_setting;
    }


    public static Intent getIntent(Context context) {
        return new Intent(context, SettingActivity.class);
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(getString(R.string.setting_title));
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                VersionCheckBean versionCheckBean = (VersionCheckBean) result;
                if (versionCheckBean != null && versionCheckBean.isRel() == false) {

                    if (versionCheckBean != null && !TextUtils.isEmpty(versionCheckBean.getData().getDownloadUrl())) {
                        updateAppUtils.serverVersionCode(versionCheckBean.getData().getWeigh())
                                .serverVersionName(versionCheckBean.getData().getVersionName())
                                .apkPath(versionCheckBean.getData().getDownloadUrl())
                                .updateInfo(versionCheckBean.getData().getContent())
                                .apkSize(versionCheckBean.getData().getPackagesize())
                                .isForce(versionCheckBean.getData().getIsCompe() == 0 ? false : true)
                                .update();
                    }
                } else {
                    Toast.makeText(getApplicationContext(), "当前已是最新版本", Toast.LENGTH_SHORT).show();
                }
                break;
            default:
                break;
        }

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ButterKnife.bind(this);
        if (updateAppUtils == null) {
            updateAppUtils = UpdateAppUtils.from(SettingActivity.this);
        }
    }

    @OnClick({R2.id.rl_item_change_password, R2.id.ll_item_app_push, R2.id.rl_item_clear_cache, R2.id.rl_item_check_for_updates, R2.id.rl_item_about_us, R2.id.tv_out_sign})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.rl_item_change_password) {
            //修改密码
            startActivity(RegisteredActivity.getIntent(mActivity, 1));

        } else if (id == R.id.ll_item_app_push) {
            //App推送消息
            showToast("亲，该功能还在开发中。。。");
        } else if (id == R.id.rl_item_clear_cache) {
            //清除缓存
            showToast("亲，该功能还在开发中。。。");
        } else if (id == R.id.rl_item_check_for_updates) {
            //检查更新
            checkVersion();
        } else if (id == R.id.rl_item_about_us) {
            //关于我们
            startActivity(AboutUsActivity.getIntent(mActivity));

        } else if (id == R.id.tv_out_sign) {
            //退出登录
            UtilsManager.getInstance(mActivity).clearShareData("city_json");
            UtilsManager.getInstance(mActivity).setShNull();
            OkGoUtil.clearToken();
            setResult(201);
            showToast("退出成功！");
            finish();
        }
    }

    /****
     * 检测版本
     */
    private void checkVersion() {

        Map<String, Object> headMap = new LinkedHashMap<>();
        String versionName = UpdateAppUtils.getAppVersionName(this);
        if (!TextUtils.isEmpty(versionName)) {
            mPresenter.getData(0, String.format(ApiConfig.HTTP_URL_VERSION_CHECK, versionName), VersionCheckBean.class, headMap, true);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1001:
                if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    updateAppUtils.download();
                } else {
                    Toast.makeText(getApplicationContext(), "授权失败,无法下载最新App", Toast.LENGTH_SHORT).show();
                }
                break;
        }
    }
}
