package com.rv.home.rv.module.ui.main.home;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.swipe.SwipeBackActivity;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.util.um.CustomShareListener;
import com.ruiwenliu.wrapper.util.um.ShareManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.bean.CarTypeListBean;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.utils.ShareBoardlistener;

import butterknife.BindView;
import butterknife.OnClick;

public class ShareImageActivity extends SwipeBackActivity<CommonPresenter> {

    @BindView(R2.id.iv_goods)
    ImageView ivGoods;
    @BindView(R2.id.tv_name)
    TextView tvName;
    @BindView(R2.id.tv_content)
    TextView tvContent;
    @BindView(R2.id.tv_price)
    TextView tvPrice;
    @BindView(R2.id.iv_code)
    ImageView ivCode;
    @BindView(R2.id.rl_body)
    RelativeLayout rlBody;
    private ShareManager shareManager;
    private CarTypeListBean.DataBeanX.DataBean mCarBean;

    public static Intent getIntent(Context context, CarTypeListBean.DataBeanX.DataBean carBean) {
        return new Intent(context, ShareImageActivity.class)
                .putExtra("carBean", carBean);
    };

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    protected int setLayout() {
        return R.layout.rv_act_share_image;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);
        mCarBean = (CarTypeListBean.DataBeanX.DataBean) getIntent().getSerializableExtra("carBean");
        GlideManager.getInstance(this).loadImage(mCarBean.getVehicleModel().getIcon(), ivGoods);
        tvName.setText(mCarBean.getVehicleModel().getName());
        tvContent.setText(mCarBean.getVehicleModel().getKeyword());
        tvPrice.setText(String.format("%1$s%2$s", mCarBean.getVehicleModel().getPrice(), this.getString(R.string.rv_day)));
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.iv_title_left, R2.id.tv_share})
    public void onViewClicked(View view) {
        int i = view.getId();
        if (i == R.id.iv_title_left) {
            finish();

        } else if (i == R.id.tv_share) {
            if (rlBody != null && getViewBitmap(rlBody) != null) {
                initShare(getViewBitmap(rlBody));
            }

        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        /** attention to this below ,must add this**/
        UMShareAPI.get(this).onActivityResult(requestCode, resultCode, data);
    }

    /**
     * 屏幕横竖屏切换时避免出现window leak的问题
     */
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        shareManager.close();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    /**
     * 获取scrollview的截屏
     */
    public  Bitmap getViewBitmap(RelativeLayout view) {
        int w = view.getWidth();
        int h = view.getHeight();
        Bitmap bmp = Bitmap.createBitmap(w, h, Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmp);
        c.drawColor(Color.WHITE);
        /** 如果不设置canvas画布为白色，则生成透明 */
        view.layout(0, 0, w, h);
        view.draw(c);
        return bmp;
    }
    /**
     * 初始化分享
     */
    private void initShare(final Bitmap bitmap) {

        if(shareManager==null){
            shareManager=new ShareManager(this, new ShareBoardlistener() {
                @Override
                public void onclick(SnsPlatform snsPlatform, SHARE_MEDIA share_media) {


                    shareManager.showShareImage(share_media,bitmap ,new CustomShareListener(mActivity){
                        @Override
                        public void onResult(SHARE_MEDIA platform) {
                            super.onResult(platform);

                            if (platform.name().equals("WEIXIN_FAVORITE")) {

                                showToast( platform + " 收藏成功啦");

                            } else {
                                if (platform != SHARE_MEDIA.MORE && platform != SHARE_MEDIA.SMS
                                        && platform != SHARE_MEDIA.EMAIL
                                        && platform != SHARE_MEDIA.FLICKR
                                        && platform != SHARE_MEDIA.FOURSQUARE
                                        && platform != SHARE_MEDIA.TUMBLR
                                        && platform != SHARE_MEDIA.POCKET
                                        && platform != SHARE_MEDIA.PINTEREST

                                        && platform != SHARE_MEDIA.INSTAGRAM
                                        && platform != SHARE_MEDIA.GOOGLEPLUS
                                        && platform != SHARE_MEDIA.YNOTE
                                        && platform != SHARE_MEDIA.EVERNOTE) {
                                    showToast( platform +"分享成功啦");

                                }

                            }

                        }
                    });
                }
            });
        }
        shareManager.open();

    }


}
