package com.base.utils.ui.snack.simple;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;

import com.base.utils.R;
import com.base.utils.ui.snack.Prompt;
import com.base.utils.ui.snack.TopSnackBar;


public class SamplePromptActivity extends AppCompatActivity {
    private TopSnackBar snackBar;
    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0:
                    if (snackBar != null) {
                        snackBar.setPromptThemBackground(Prompt.SUCCESS).setText("登录成功").setDuration(TopSnackBar.LENGTH_LONG).show();
                    }
                    break;
                case 1:
                    if (snackBar != null) {
                        snackBar.setPromptThemBackground(Prompt.ERROR).setText("登录失败").setDuration(TopSnackBar.LENGTH_LONG).show();
                    }
                    break;
                default:
                    break;
            }
        }
    };
    Runnable gotoLoginActSuccess = new Runnable() {
        @Override
        public void run() {
            Message msg = new Message();
            msg.what = 0;
            mHandler.sendMessage(msg);
        }
    };
    Runnable gotoLoginActFail = new Runnable() {
        @Override
        public void run() {
            Message msg = new Message();
            msg.what = 1;
            mHandler.sendMessage(msg);
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.top_snackbar_view_prompt_test_activity);
    }

    public void promptOnClick(View v)  {
        final ViewGroup viewGroup = (ViewGroup) findViewById(android.R.id.content).getRootView();
        int i = v.getId();
        if (i == R.id.top_snackbar_view_success) {
            snackBar = TopSnackBar.make(viewGroup, "成功...", TopSnackBar.LENGTH_SHORT, TopSnackBar.APPEAR_FROM_TOP_TO_DOWN);
            snackBar.setAction("取消", new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                }
            });
            snackBar.setPromptThemBackground(Prompt.SUCCESS);
            snackBar.show();

        } else if (i == R.id.top_snackbar_view_error) {
            snackBar = TopSnackBar.make(viewGroup, "错误...", TopSnackBar.LENGTH_LONG, TopSnackBar.APPEAR_FROM_TOP_TO_DOWN);
            snackBar.addIcon(R.drawable.icon_lion, 100, 100);
            snackBar.setAction("取消", new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                }
            });
            snackBar.setPromptThemBackground(Prompt.ERROR);
            snackBar.show();

        } else if (i == R.id.top_snackbar_view_warning) {
            snackBar = TopSnackBar.make(viewGroup, "警告...", TopSnackBar.LENGTH_LONG, TopSnackBar.APPEAR_FROM_TOP_TO_DOWN);
            snackBar.addIcon(R.drawable.icon_lion, 100, 100);
            snackBar.setAction("取消", new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                }
            });
            snackBar.setPromptThemBackground(Prompt.WARNING);
            snackBar.show();

        } else if (i == R.id.top_snackbar_view_loginSuccess) {
            snackBar = TopSnackBar.make(viewGroup, "正在登录，请稍后...", TopSnackBar.LENGTH_INDEFINITE, TopSnackBar.APPEAR_FROM_TOP_TO_DOWN);
            snackBar.setAction("取消", new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                }
            });
            snackBar.setPromptThemBackground(Prompt.SUCCESS);
            snackBar.addIconProgressLoading(0, true, false);
            snackBar.show();
            mHandler.postDelayed(gotoLoginActSuccess, 5000);

        } else if (i == R.id.top_snackbar_view_loginFail) {
            snackBar = TopSnackBar.make(viewGroup, "正在登录，请稍后...", TopSnackBar.LENGTH_INDEFINITE, TopSnackBar.APPEAR_FROM_TOP_TO_DOWN);
            snackBar.setAction("取消", new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                }
            });
            snackBar.setPromptThemBackground(Prompt.SUCCESS);
            snackBar.addIconProgressLoading(0, true, false);
            snackBar.show();
            mHandler.postDelayed(gotoLoginActFail, 5000);

        } else {
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        final ViewGroup viewGroup = (ViewGroup) findViewById(android.R.id.content).getRootView();
        TopSnackBar snackBar = TopSnackBar.make(viewGroup, "正在加载中...", TopSnackBar.LENGTH_INDEFINITE, TopSnackBar.APPEAR_FROM_TOP_TO_DOWN);
        snackBar.setAction("取消", new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        snackBar.setPromptThemBackground(Prompt.SUCCESS);
        snackBar.addIconProgressLoading(0, true, false);
        snackBar.show();
    }


}
