package com.base.utils.ui.snack;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;

import com.base.utils.R;

/**
 * 弹出顶部提示
 */

public class TopSnackBarUtil {
    //显示成功提示
    public static void showSuccessShort(Activity activity,
                                        CharSequence text) {
        show(activity, text, Prompt.SUCCESS, TopSnackBar.LENGTH_SHORT, false, null);
    }

    public static void showSuccessLong(Activity activity,
                                       CharSequence text) {
        show(activity, text, Prompt.SUCCESS, TopSnackBar.LENGTH_LONG, false, null);
    }

    //显示警告信息
    public static void showWarnShort(Activity activity,
                                     CharSequence text) {
        show(activity, text, Prompt.WARNING, TopSnackBar.LENGTH_SHORT, false, null);
    }

    public static void showWarnLong(Activity activity,
                                    CharSequence text) {
        show(activity, text, Prompt.WARNING, TopSnackBar.LENGTH_LONG, false, null);
    }

    //显示错误信息
    public static void showErrorShort(Activity activity,
                                      CharSequence text) {
        show(activity, text, Prompt.ERROR, TopSnackBar.LENGTH_SHORT, false, null);
    }

    public static void showErrorLong(Activity activity,
                                     CharSequence text) {
        show(activity, text, Prompt.ERROR, TopSnackBar.LENGTH_LONG, false, null);
    }

    //显示进度信息 ,如需要关闭，则再弹出一个 结果，如成功、警告、错误
    public static void showProgress(Activity activity, CharSequence text) {
        showProgress(activity, text, false, null);
    }

    //显示进度信息 ,如需要关闭，则再弹出一个 结果，如成功、警告、错误
    public static void showProgress(Activity activity, CharSequence text, boolean isSetAction,
                                    View.OnClickListener actionListener) {
        final ViewGroup viewGroup = (ViewGroup) activity.findViewById(android.R.id.content).getRootView();
        TopSnackBar snackBar = TopSnackBar.make(viewGroup, text, TopSnackBar.LENGTH_INDEFINITE, TopSnackBar.APPEAR_FROM_TOP_TO_DOWN);
        if (isSetAction) {
            snackBar.setAction(activity.getString(R.string.resource_public_cancel), actionListener);
        }
        snackBar.addIconProgressLoading(0, true, false);
        snackBar.show();
    }

    /**
     * LENGTH_INDEFINITE
     * LENGTH_SHORT
     * LENGTH_LONG
     */
    private static void show(Activity activity,
                             CharSequence text,
                             Prompt prompt,
                             int duration,
                             boolean isSetAction,
                             View.OnClickListener actionListener) {
        final ViewGroup viewGroup = (ViewGroup) activity.findViewById(android.R.id.content).getRootView();
        TopSnackBar snackBar = TopSnackBar.make(viewGroup, text, duration, TopSnackBar.APPEAR_FROM_TOP_TO_DOWN);
        if (isSetAction) {
            snackBar.setAction(activity.getString(R.string.resource_public_cancel), actionListener);
        }
        snackBar.setPromptThemBackground(prompt);
        snackBar.show();
    }
}
