/**
 * @file XFooterView.java
 * @create Mar 31, 2012 9:33:43 PM
 * @author Maxwin
 * @description XListView's footer
 */
package com.base.utils.ui.refresh.water.view;


import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.base.utils.R;


public class WaterDropListViewFooter extends LinearLayout {
    private Context mContext;

    private View mContentView;
    private View mProgressBar;
    private TextView mHintView;
    private TextView mProgressText;
    private LinearLayout mProgressLayout;

    public enum STATE {
        normal,
        ready,
        loading
    }

    public WaterDropListViewFooter(Context context) {
        this(context, null);
    }

    public WaterDropListViewFooter(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WaterDropListViewFooter(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context);
    }


    public void setState(STATE state) {
        mHintView.setVisibility(View.INVISIBLE);
        mProgressBar.setVisibility(View.INVISIBLE);
        mHintView.setVisibility(View.INVISIBLE);
        mProgressText.setVisibility(View.INVISIBLE);
        mProgressLayout.setVisibility(View.INVISIBLE);
        if (state == STATE.ready) {
            mHintView.setVisibility(View.VISIBLE);
            mHintView.setText(getResources().getString(R.string.listfooterview_ready));
        } else if (state == STATE.loading) {
            mProgressBar.setVisibility(View.VISIBLE);
            mProgressLayout.setVisibility(View.VISIBLE);
            mProgressText.setVisibility(View.VISIBLE);
        } else {
            mHintView.setVisibility(View.VISIBLE);
            mHintView.setText(getResources().getString(R.string.listfooterview_normal));
        }
    }

    public void setBottomMargin(int height) {
        if (height < 0) return;
        LayoutParams lp = (LayoutParams) mContentView.getLayoutParams();
        lp.bottomMargin = height;
        mContentView.setLayoutParams(lp);
    }

    public int getBottomMargin() {
        LayoutParams lp = (LayoutParams) mContentView.getLayoutParams();
        return lp.bottomMargin;
    }

    /**
     * normal status
     */
    public void normal() {
        mHintView.setVisibility(View.VISIBLE);
        mProgressBar.setVisibility(View.GONE);
        mProgressLayout.setVisibility(View.GONE);
        mProgressText.setVisibility(View.GONE);
    }


    /**
     * loading status
     */
    public void loading() {
        mHintView.setVisibility(View.GONE);
        mProgressBar.setVisibility(View.VISIBLE);
        mProgressLayout.setVisibility(View.VISIBLE);
        mProgressText.setVisibility(View.VISIBLE);
    }

    /**
     * hide footer when disable pull load more
     */
    public void hide() {
        LayoutParams lp = (LayoutParams) mContentView.getLayoutParams();
        lp.height = 0;
        mContentView.setLayoutParams(lp);
    }
    public void setHintViewText(String text){
        mHintView.setText(text);
    }

    /**
     * show footer
     */
    public void show() {
        LayoutParams lp = (LayoutParams) mContentView.getLayoutParams();
        lp.height = LayoutParams.WRAP_CONTENT;
        mContentView.setLayoutParams(lp);
    }

    private void init(Context context) {
        mContext = context;
        LinearLayout moreView = (LinearLayout) LayoutInflater.from(mContext).inflate(R.layout.waterdroplistview_footer, null);
        addView(moreView);
        moreView.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));

        mContentView = moreView.findViewById(R.id.water_drop_list_view_footer_content);
        mProgressBar = moreView.findViewById(R.id.water_drop_list_view_footer_progressbar);
        mHintView = (TextView) moreView.findViewById(R.id.water_drop_list_view_footer_hint_text_view);
        mProgressLayout = (LinearLayout) moreView.findViewById(R.id.progress_layout);
        mProgressText = (TextView) moreView.findViewById(R.id.txt_progress_text);
    }


}
