package com.base.utils.tools.android.version;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

/**
 * 版本更新
 * 1.得到本程序的版本号
 * 2.请求服务器版本号
 * 3.比对，服务器版本号大，就提示用户下载安装
 * 4.启动下载服务、在通知栏更新
 * <p>
 * 注意：判断有无网络、是否WIFI
 */

public class VersionUpdateUtil {


    //获取当前所安装的版本名
    public static String getVersionName(Context context) {
        PackageInfo packageInfo = getPackageInfo(context);
        if (packageInfo != null) {
            return packageInfo.versionName;
        }
        return null;
    }

    //获取当前所安装的版本号
    public static int getVersionCode(Context context) {
        PackageInfo packageInfo = getPackageInfo(context);
        if (packageInfo != null) {
            return packageInfo.versionCode;
        }
        return 0;
    }

    private static PackageInfo getPackageInfo(Context context) {

        try {
            PackageManager pm = context.getPackageManager();
            return pm.getPackageInfo(context.getPackageName(), PackageManager.GET_CONFIGURATIONS);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


}
