package com.rv.travel.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.base.utils.ui.dialog.DialogPlusUtil;
import com.base.utils.ui.dialog.DialogUtil;
import com.frame.base.FrameApp;
import com.orhanobut.dialogplus.DialogPlus;
import com.rv.travel.R;
import com.rv.travel.bean.BeanTravelMember;
import com.rv.travel.bean.BeanTravelMoneyDetail;
import com.rv.travel.fragment.TravelFragmentCommitOrder;

import java.util.List;

public class TravelDialogUtil {
    public interface OnDialogDoneCallback<T> {
        void done(T t);
    }


    //选择出游人
    public static void showSelectTravel(Context context, final List<BeanTravelMember> data,
                                        final OnDialogDoneCallback<BeanTravelMember> callback) {
        final String[] items;

        if (data == null || data.size() == 0) {
            items = new String[]{"无,去添加！"};
        } else {
            items = new String[data.size()];
            int i = 0;
            for (BeanTravelMember bean : data) {
                String text = bean.getName();
                items[i] = text;
                i += 1;
            }
        }
        DialogUtil.getItemDialog(context, items, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (callback != null) {
                    if (data != null && data.size() > 0) {
                        callback.done(data.get(which));
                    } else {
                        callback.done(null);
                    }
                }

            }
        }).setTitle("选择出游人").create().show();
    }

    public static void showCommitOrderMoneyDetail(final TravelFragmentCommitOrder travelFragmentCommitOrder) {
        BeanTravelMoneyDetail moneyDetail = travelFragmentCommitOrder.getMoneyDetailBean();
        if (moneyDetail == null) {
            travelFragmentCommitOrder.showToastShort("明细数据为空");
            return;
        }
        View dialogView = LayoutInflater.from(travelFragmentCommitOrder.getContext()).inflate(R.layout.dialog_order_money_detail, null);
        TravelDialogUtil.mDialogPlus = DialogPlusUtil.getDialogPlus(travelFragmentCommitOrder.getContext(), dialogView)
                .create();
        TravelDialogUtil.mDialogPlus.show();
        TextView moneyText = dialogView.findViewById(R.id.commit_order_money_detail_money_text);

        TextView adultDesText = dialogView.findViewById(R.id.commit_order_money_detail_adult_des_text);
        TextView childDesText = dialogView.findViewById(R.id.commit_order_money_detail_child_des_text);
        TextView adultTotalText = dialogView.findViewById(R.id.commit_order_money_detail_adult_total_money_text);
        TextView childTotalText = dialogView.findViewById(R.id.commit_order_money_detail_child_total_money_text);
        //订单价格
        //moneyText.setText(moneyDetail.getOrderAmount());
        moneyText.setText(moneyDetail.getRealAmount());
        //大人总价格
        if (TextUtil.isEmpty(moneyDetail.getNumber())||moneyDetail.getNumber().equals("0")){
            adultTotalText.setText("0");
            adultDesText.setText("0");
        }else {
            adultTotalText.setText(moneyDetail.getTotalPrice());
            adultDesText.setText(moneyDetail.getPrice() + "/" + moneyDetail.getNumber());
        }
        //儿童总价格
        if (TextUtil.isEmpty(moneyDetail.getChildNumber())||moneyDetail.getChildNumber().equals("0")){
            childTotalText.setText("0");
            childDesText.setText("0");
        }else {
            childTotalText.setText(moneyDetail.getTotalChildPrice());
            childDesText.setText(moneyDetail.getChildPrice() + "/" + moneyDetail.getChildNumber());
        }

        dialogView.findViewById(R.id.money_detail_close).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismissDialogPlus();
            }
        });

        dialogView.findViewById(R.id.commit_order_button).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismissDialogPlus();
                FrameApp.getMainHandler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        travelFragmentCommitOrder.commit();
                    }
                }, 600);
            }
        });
    }


    @SuppressLint("StaticFieldLeak")
    public static DialogPlus mDialogPlus = null;

    public static void dismissDialogPlus() {
        if (mDialogPlus != null) {
            mDialogPlus.dismiss();
            mDialogPlus = null;
        }
    }

    private static boolean isPayWx = true;//默认选择微信支付


    //选择支付
    public static void showPaySelectDialog(final Context context, String price, final OnDialogDoneCallback<Boolean> listener) {
        isPayWx = true;
        dismissDialogPlus();
        View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_order_select_pay, null);
        TravelDialogUtil.mDialogPlus = DialogPlusUtil.getDialogPlus(context, dialogView)
                .create();
        TravelDialogUtil.mDialogPlus.show();
        final TextView priceView = dialogView.findViewById(R.id.select_pay_price);
        priceView.setText(price);
        final ImageView payWx = dialogView.findViewById(R.id.select_pay_wx);
        final ImageView payZfb = dialogView.findViewById(R.id.select_pay_zfb);
        payWx.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                isPayWx = true;
                payWx.setImageResource(R.mipmap.common_icon_pay_round);
                payZfb.setImageResource(R.mipmap.common_icon_round);
            }
        });
        payZfb.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (true){
                    Toast.makeText(context, "暂不支持", Toast.LENGTH_SHORT).show();
                    return;
                }
                isPayWx = false;
                payZfb.setImageResource(R.mipmap.common_icon_pay_round);
                payWx.setImageResource(R.mipmap.common_icon_round);
            }
        });
        dialogView.findViewById(R.id.select_pay_close).
                setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismissDialogPlus();
                    }
                });
        dialogView.findViewById(R.id.inquiry_doctor_pay_submit).
                setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismissDialogPlus();

                        if (listener != null) {
                            listener.done(isPayWx);
                        }
                    }
                });
    }


}
