package com.rv.travel.api;

import com.base.utils.tools.android.GetUrlUtil;
import com.base.utils.tools.android.LogUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import com.rv.travel.bean.BeanBanner;
import com.rv.travel.bean.BeanCheckCollection;
import com.rv.travel.bean.BeanHot;
import com.rv.travel.bean.BeanOrderPay;
import com.rv.travel.bean.BeanOrderResponse;
import com.rv.travel.bean.BeanRim;
import com.rv.travel.bean.BeanTravelMember;
import com.rv.travel.bean.BeanTravelMoneyDetail;
import com.yuyife.okgo.OkGoUtil;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiUtil {
    //登录
    public static void getToken(String username, String password, final OnApiResponseCallback<Boolean, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("type", "1");//0-验证码登录 1-密码登录
        map.put("username", username);
        map.put("password", password);
        String url = GetUrlUtil.getUrl(TravelApi.TRAVEL_LOGIN, map);
        OkGoUtil.postJson(url, new HashMap<String, String>(), new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getToken:" + response.body());

                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }
                String token = OkGoUtil.getStringToJson(response.body(), "token");
                OkGoUtil.setToken(token);
                callback.done(true, OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getToken:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getToken:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

    //获取公司详情
    public static void getCompanyData(String id, final OnApiResponseCallback<List<BeanBanner>, String> callback) {
        Map<String, String> map = new HashMap<>();
        String url = TravelApi.QUERY_COMPANY_DETAIL + id;
        OkGoUtil.getMap(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getCompanyData:" + response.body());
                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getCompanyData:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getCompanyData:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

    //获取banner 首页
    public static void getBannerDataMain(final OnApiResponseCallback<List<BeanBanner>, String> callback) {
        Map<String, String> map = new HashMap<>();
        OkGoUtil.getMap(TravelApi.QUERY_BANNER_MAIN, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getBannerDataMain:" + response.body());
                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                JSONArray array = OkGoUtil.getListToJson(response.body(), ApiKey.DATA);
                List<BeanBanner> list = new ArrayList<BeanBanner>();
                if (array != null && array.length() > 0) {
                    for (int i = 0; i < array.length(); i++) {
                        BeanBanner bean = null;
                        try {
                            bean = new Gson().fromJson(array.getJSONObject(i).toString(),
                                    new TypeToken<BeanBanner>() {
                                    }.getType());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        list.add(bean);
                    }
                }
                callback.done(list, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getBannerDataMain:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getBannerDataMain:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

    //获取banner 热门
    public static void getBannerDataHot(String id, final OnApiResponseCallback<List<BeanBanner>, String> callback) {
        Map<String, String> map = new HashMap<>();
        String url = TravelApi.QUERY_BANNER_HOT + id;
        OkGoUtil.getMap(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getBannerDataHot:" + response.body());
                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                JSONArray array = OkGoUtil.getListToJson(response.body(), ApiKey.DATA);
                List<BeanBanner> list = new ArrayList<BeanBanner>();
                if (array != null && array.length() > 0) {
                    for (int i = 0; i < array.length(); i++) {
                        BeanBanner bean = null;
                        try {
                            bean = new Gson().fromJson(array.getJSONObject(i).toString(),
                                    new TypeToken<BeanBanner>() {
                                    }.getType());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        list.add(bean);
                    }
                }
                callback.done(list, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getBannerDataHot:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getBannerDataHot:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }


    //获取热门游 hot 0-否,1-是
    public static void getHotData(String query, String page, String limit, final OnApiResponseCallback<List<BeanHot>, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("hot", "1");
        map.put("query", query);
        map.put("page", page);
        map.put("limit", limit);
        OkGoUtil.getMap(TravelApi.QUERY_HOT_LIST, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getHotData:" + response.body());
                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }
                JSONArray array = OkGoUtil.getListToJson(response.body(), ApiKey.DATA);
                List<BeanHot> list = new ArrayList<BeanHot>();
                if (array != null && array.length() > 0) {
                    for (int i = 0; i < array.length(); i++) {
                        BeanHot bean = null;
                        try {
                            bean = new Gson().fromJson(array.getJSONObject(i).toString(),
                                    new TypeToken<BeanHot>() {
                                    }.getType());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        list.add(bean);
                    }
                }
                callback.done(list, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getHotData:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getHotData:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

    //获取周边游
    //latitudel=22.954205&longitude=113.879421
    public static void getRimData(String tagId, String query, String page, String limit, final OnApiResponseCallback<List<BeanRim>, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("tagId", tagId);
        map.put("query", query);
        map.put("page", page);
        map.put("limit", limit);
        map.put("latitudel", "22.954205");
        map.put("longitude", "113.879421");
        OkGoUtil.getMap(TravelApi.QUERY_RIM_LIST, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getRimData:" + response.body());

                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }
                List<BeanRim> list = new ArrayList<BeanRim>();

                JSONObject data = OkGoUtil.getJsonObjectToJson(response.body(), ApiKey.DATA);
                if (data != null) {
                    JSONArray array = OkGoUtil.getListToJson(data.toString(), ApiKey.DATA);
                    if (array != null && array.length() > 0) {
                        for (int i = 0; i < array.length(); i++) {
                            BeanRim bean = null;
                            try {
                                bean = new Gson().fromJson(array.getJSONObject(i).toString(),
                                        new TypeToken<BeanRim>() {
                                        }.getType());
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                            list.add(bean);
                        }
                    }
                }
                callback.done(list, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getRimData:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getRimData:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

    //获取出游人信息 1-儿童,0-成年人
    public static void getTravelMember(String isChild, final OnApiResponseCallback<List<BeanTravelMember>, String> callback) {
        Map<String, String> map = new HashMap<>();
        //map.put("isChild", isChild);

        String url = TravelApi.QUERY_TRAVEL_MEMBER + isChild;
        OkGoUtil.getMap(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getTravelMember:" + response.body());

                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                JSONArray array = OkGoUtil.getListToJson(response.body(), ApiKey.DATA);
                List<BeanTravelMember> list = new ArrayList<BeanTravelMember>();
                if (array != null && array.length() > 0) {
                    for (int i = 0; i < array.length(); i++) {
                        BeanTravelMember bean = null;
                        try {
                            bean = new Gson().fromJson(array.getJSONObject(i).toString(),
                                    new TypeToken<BeanTravelMember>() {
                                    }.getType());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        list.add(bean);
                    }
                }
                callback.done(list, null);

            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getTravelMember:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getTravelMember:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

    //获取费用明显 goodId=37&spePriceId=109&tourUserIds=4,5
//    商品id	goodId	int		是
//    具体商品（商品项）id	spePriceId	string		是
//    成人数量 adultNum
//    儿童数量 childNum
    public static void getTravelMoneyDetail(
            String goodId,
            String spePriceId,
            String adultNum,
            String childNum,
            final OnApiResponseCallback<BeanTravelMoneyDetail, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("goodId", goodId);
        map.put("spePriceId", spePriceId);
        map.put("number", adultNum);
        map.put("childNumber", childNum);

        String url = TravelApi.QUERY_TRAVEL_MONEY_DETAIL;
        OkGoUtil.getMap(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getTravelMoneyDetail:" + response.body());

                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                JSONObject data = OkGoUtil.getJsonObjectToJson(response.body(), ApiKey.DATA);
                BeanTravelMoneyDetail bean = null;
                if (data != null) {
                    bean = new Gson().fromJson(data.toString(), new TypeToken<BeanTravelMoneyDetail>() {
                    }.getType());


                }
                callback.done(bean, null);

            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getTravelMoneyDetail:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getTravelMoneyDetail:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

    //确认下单
    public static void commitOrder(
            String contactEmail,
            String contactMan,
            String contactPhone,
            String endAddr,
            String endTime,
            String goodId,
            String tourUserIds,
            String spePriceId,
            String startAddr,
            String startCompanyId,
            String startTime,
            final OnApiResponseCallback<BeanOrderResponse, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("contactEmail", contactEmail);
        map.put("contactMan", contactMan);
        map.put("contactPhone", contactPhone);
        map.put("endAddr", endAddr);
        map.put("endTime", endTime);
        map.put("goodId", goodId);
        map.put("tourUserIds", tourUserIds);
        map.put("spePriceId", spePriceId);
        map.put("startAddr", startAddr);
        map.put("startCompanyId", startCompanyId);
        map.put("startTime", startTime);
        String url = TravelApi.COMMIT_ORDER;
        OkGoUtil.postJson(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess commitOrder:" + response.body());

                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                JSONObject data = OkGoUtil.getJsonObjectToJson(response.body(), ApiKey.DATA);
                BeanOrderResponse bean = null;
                if (data != null) {
                    bean = new Gson().fromJson(data.toString(), new TypeToken<BeanOrderResponse>() {
                    }.getType());
                }
                callback.done(bean, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError commitOrder:" + response.body());
                LogUtil.e(ApiUtil.class, "onError commitOrder:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }


    /**
     * 订单支付
     */
    public static void payOrder(
            String orderNo,
            String payWay,
            String type,
            final OnApiResponseCallback<BeanOrderPay, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("orderNo", orderNo);
        map.put("payWay", payWay);
        map.put("type", type);
        String url = TravelApi.COMMIT_ORDER_PAY;
        OkGoUtil.postJson(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess commitOrder:" + response.body());

                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                JSONObject data = OkGoUtil.getJsonObjectToJson(response.body(), ApiKey.DATA);
                BeanOrderPay bean = null;
                if (data != null) {
                    bean = new Gson().fromJson(data.toString(), new TypeToken<BeanOrderPay>() {
                    }.getType());
                }
                callback.done(bean, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError commitOrder:" + response.body());
                LogUtil.e(ApiUtil.class, "onError commitOrder:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }


    /**
     * 添加收藏
     */
    public static void addCollection(
            String type,
            String typeId,
            String name,
            String cover,
            String price,
            String unit,
            final OnApiResponseCallback<String, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("unit", unit);
        map.put("price", price);
        map.put("cover", cover);
        map.put("name", name);
        map.put("typeId", typeId);
        map.put("type", type);
        String url = TravelApi.COMMIT_COLLECT_ADD;
        OkGoUtil.postJson(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess commitOrder:" + response.body());

                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                JSONObject data = OkGoUtil.getJsonObjectToJson(response.body(), ApiKey.DATA);
                String bean = null;
                if (data != null) {
                    bean = new Gson().fromJson(data.toString(), new TypeToken<String>() {
                    }.getType());
                }
                callback.done(bean, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError commitOrder:" + response.body());
                LogUtil.e(ApiUtil.class, "onError commitOrder:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }


    public static void getIsCollection(String id, final OnApiResponseCallback<BeanCheckCollection, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("id",id);
        map.put("type","2");
        String url = TravelApi.COMMIT_COLLECT_IS;
        OkGoUtil.getMap(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess getBannerDataHot:" + response.body());
                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                JSONObject data = OkGoUtil.getJsonObjectToJson(response.body(), ApiKey.DATA);
                BeanCheckCollection bean = null;
                if (data != null) {
                    bean = new Gson().fromJson(data.toString(), new TypeToken<BeanCheckCollection>() {
                    }.getType());
                }
                callback.done(bean, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError getBannerDataHot:" + response.body());
                LogUtil.e(ApiUtil.class, "onError getBannerDataHot:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

    /**
     *取消收藏
     */
    public static void cancelCollection(
            String id,
            String status,
            final OnApiResponseCallback<String, String> callback) {
        Map<String, String> map = new HashMap<>();
        map.put("id", id);
        map.put("status", status);
        String url = TravelApi.COMMIT_COLLECT_REMOVE;
        OkGoUtil.postJson(url, map, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

                LogUtil.e(ApiUtil.class, "onSuccess commitOrder:" + response.body());

                if (callback == null) return;
                String status = OkGoUtil.getStringToJson(response.body(), ApiKey.STATUS);
                if (status == null) {
                    callback.done(null, ApiKey.ERROR_NO_STATUS);
                    return;
                }
                if (!status.equals(ApiKey.STATUS_200)) {
                    callback.done(null, ApiKey.ERROR_PREFIX + "--status" + status + "--message" + OkGoUtil.getStringToJson(response.body(), ApiKey.MESSAGE));
                    return;
                }

                String data = OkGoUtil.getStringToJson(response.body(), ApiKey.DATA);
                callback.done(data, null);
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);
                LogUtil.e(ApiUtil.class, "onError commitOrder:" + response.body());
                LogUtil.e(ApiUtil.class, "onError commitOrder:" + response.message());
                if (callback != null) {
                    callback.done(null, response.message());
                }
            }
        });
    }

}
