package com.frame.rv.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.frame.rv.R;

import java.util.List;

public class BaseTipsLayout extends RelativeLayout {
    public void setData(List data){
        if (data!=null&&data.size()>0){
            this.setVisibility(View.GONE);
        }else {
            this.setVisibility(View.VISIBLE);
            this.progressBar.setVisibility(GONE);
            this.tipsImageView.setVisibility(VISIBLE);
            this.buttonView.setVisibility(GONE);
        }
    }
    public BaseTipsLayout(Context context) {
        super(context);
        init(context);
    }

    public BaseTipsLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);

    }

    public BaseTipsLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private ImageView tipsImageView;
    private TextView buttonView;
    private ProgressBar progressBar;

    private void init(Context context) {

        View view = LayoutInflater.from(context).inflate(R.layout.layout_tips, this, true);
        tipsImageView = view.findViewById(R.id.tips_image_view);
        buttonView = view.findViewById(R.id.tips_button_view);
        progressBar = view.findViewById(R.id.tips_progress_bar);
        buttonView.setVisibility(GONE);
        tipsImageView.setVisibility(GONE);
    }

    public void setTipsImageView(Integer res) {
        tipsImageView.setImageResource(res);
    }

}
