package com.frame.base.browse;

import android.os.Bundle;
import android.support.annotation.IntegerRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.base.utils.R;
import com.base.utils.base.BaseFragment;
import com.base.utils.ui.image.pinch.PinchImageView;
import java.util.Objects;

/**
 * 浏览图片的碎片
 * FragmentImageBrowse
 */

public class FragmentImageBrowse extends BaseFragment {
    final private static String KEY_IMAGE_INT = "image_int";
    final private static String KEY_IMAGE_STRING = "image_string";

    private int getImageInt() {
        if (getArguments() == null) return 0;
        return getArguments().getInt(FragmentImageBrowse.KEY_IMAGE_INT);
    }

    private String getImageString() {
        if (getArguments() == null) return "";
        return getArguments().getString(FragmentImageBrowse.KEY_IMAGE_STRING);
    }

    public static FragmentImageBrowse getInstance(@IntegerRes int imageRes) {
        FragmentImageBrowse instance = new FragmentImageBrowse();
        Bundle bundle = new Bundle();
        bundle.putInt(FragmentImageBrowse.KEY_IMAGE_INT, imageRes);
        instance.setArguments(bundle);
        return instance;
    }

    public static FragmentImageBrowse getInstance(String imageUrl) {
        FragmentImageBrowse instance = new FragmentImageBrowse();
        Bundle bundle = new Bundle();
        bundle.putString(FragmentImageBrowse.KEY_IMAGE_STRING, imageUrl);
        instance.setArguments(bundle);
        return instance;
    }

    PinchImageView pinchImageView;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_image_browse, container, false);
        pinchImageView = view.findViewById(R.id.image_browse_pinch_image_view);
        onData();
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onView();
    }

    @Override
    public void onData() {
    }

    @Override
    public void onView() {
        if (getImageInt() != 0) {
            pinchImageView.setImageResource(getImageInt());
        } else {
//            GlideManager.getInstance(baseContext).loadImage(getImageString(), pinchImageView);
        }
        pinchImageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Objects.requireNonNull(getActivity()).finish();
            }
        });
    }
}
