/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.widgets;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.os.Build;
import android.view.View;
import android.view.WindowInsets;
import com.umeng.socialize.shareboard.widgets.WindowInsetsCompat;

class ViewCompat {
    private static final long FAKE_FRAME_TIME = 10L;
    private static final ViewCompatImpl IMPL;

    ViewCompat() {
    }

    static void postInvalidateOnAnimation(View view) {
        IMPL.postInvalidateOnAnimation(view);
    }

    static void postOnAnimation(View view, Runnable action) {
        IMPL.postOnAnimation(view, action);
    }

    static boolean canScrollHorizontally(View v, int direction) {
        return IMPL.canScrollHorizontally(v, direction);
    }

    public static void setOnApplyWindowInsetsListener(View v, OnApplyWindowInsetsListener listener) {
        IMPL.setOnApplyWindowInsetsListener(v, listener);
    }

    public static WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat insets) {
        return IMPL.onApplyWindowInsets(view, insets);
    }

    public static WindowInsetsCompat dispatchApplyWindowInsets(View view, WindowInsetsCompat insets) {
        return IMPL.dispatchApplyWindowInsets(view, insets);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 24 ? new Api24ViewCompatImpl() : (version >= 23 ? new MarshmallowViewCompatImpl() : (version >= 21 ? new LollipopViewCompatImpl() : (version >= 19 ? new KitKatViewCompatImpl() : (version >= 18 ? new JbMr2ViewCompatImpl() : (version >= 17 ? new JbMr1ViewCompatImpl() : (version >= 16 ? new JBViewCompatImpl() : (version >= 15 ? new ICSMr1ViewCompatImpl() : (version >= 14 ? new ICSViewCompatImpl() : (version >= 11 ? new HCViewCompatImpl() : new BaseViewCompatImpl())))))))));
    }

    private static class Api24ViewCompatImpl
    extends MarshmallowViewCompatImpl {
        private Api24ViewCompatImpl() {
        }
    }

    private static class MarshmallowViewCompatImpl
    extends LollipopViewCompatImpl {
        private MarshmallowViewCompatImpl() {
        }
    }

    @TargetApi(value=20)
    private static class LollipopViewCompatImpl
    extends KitKatViewCompatImpl {
        private LollipopViewCompatImpl() {
        }

        @Override
        public void setOnApplyWindowInsetsListener(View view, final OnApplyWindowInsetsListener listener) {
            if (listener == null) {
                view.setOnApplyWindowInsetsListener(null);
                return;
            }
            final OnApplyWindowInsetsListenerBridge bridge = new OnApplyWindowInsetsListenerBridge(){

                @Override
                public Object onApplyWindowInsets(View v, Object insets) {
                    WindowInsetsCompat compatInsets = WindowInsetsCompat.wrap(insets);
                    compatInsets = listener.onApplyWindowInsets(v, compatInsets);
                    return WindowInsetsCompat.unwrap(compatInsets);
                }
            };
            view.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                public WindowInsets onApplyWindowInsets(View view, WindowInsets insets) {
                    return (WindowInsets)bridge.onApplyWindowInsets(view, insets);
                }
            });
        }

        @Override
        public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
            return WindowInsetsCompat.wrap(LollipopViewCompatImpl.onApplyWindowInsets(v, WindowInsetsCompat.unwrap(insets)));
        }

        private static Object onApplyWindowInsets(View v, Object insets) {
            WindowInsets unwrapped = (WindowInsets)insets;
            WindowInsets result = v.onApplyWindowInsets(unwrapped);
            if (result != unwrapped) {
                insets = new WindowInsets(result);
            }
            return insets;
        }

        @Override
        public WindowInsetsCompat dispatchApplyWindowInsets(View v, WindowInsetsCompat insets) {
            return WindowInsetsCompat.wrap(LollipopViewCompatImpl.dispatchApplyWindowInsets(v, WindowInsetsCompat.unwrap(insets)));
        }

        private static Object dispatchApplyWindowInsets(View v, Object insets) {
            WindowInsets unwrapped = (WindowInsets)insets;
            WindowInsets result = v.dispatchApplyWindowInsets(unwrapped);
            if (result != unwrapped) {
                insets = new WindowInsets(result);
            }
            return insets;
        }
    }

    private static class KitKatViewCompatImpl
    extends JbMr2ViewCompatImpl {
        private KitKatViewCompatImpl() {
        }
    }

    private static class JbMr2ViewCompatImpl
    extends JbMr1ViewCompatImpl {
        private JbMr2ViewCompatImpl() {
        }
    }

    private static class JbMr1ViewCompatImpl
    extends JBViewCompatImpl {
        private JbMr1ViewCompatImpl() {
        }
    }

    @TargetApi(value=16)
    static class JBViewCompatImpl
    extends ICSMr1ViewCompatImpl {
        JBViewCompatImpl() {
        }

        @Override
        public void postInvalidateOnAnimation(View view) {
            view.postInvalidateOnAnimation();
        }

        @Override
        public void postOnAnimation(View view, Runnable action) {
            view.postOnAnimation(action);
        }
    }

    static class ICSMr1ViewCompatImpl
    extends ICSViewCompatImpl {
        ICSMr1ViewCompatImpl() {
        }
    }

    @TargetApi(value=14)
    static class ICSViewCompatImpl
    extends HCViewCompatImpl {
        ICSViewCompatImpl() {
        }

        @Override
        public boolean canScrollHorizontally(View v, int direction) {
            return v.canScrollHorizontally(direction);
        }
    }

    @TargetApi(value=11)
    static class HCViewCompatImpl
    extends BaseViewCompatImpl {
        HCViewCompatImpl() {
        }

        @Override
        long getFrameTime() {
            return ValueAnimator.getFrameDelay();
        }
    }

    static class BaseViewCompatImpl
    implements ViewCompatImpl {
        BaseViewCompatImpl() {
        }

        @Override
        public boolean canScrollHorizontally(View v, int direction) {
            return false;
        }

        @Override
        public void postInvalidateOnAnimation(View view) {
            view.invalidate();
        }

        @Override
        public void postOnAnimation(View view, Runnable action) {
            view.postDelayed(action, this.getFrameTime());
        }

        @Override
        public void setOnApplyWindowInsetsListener(View view, OnApplyWindowInsetsListener listener) {
        }

        long getFrameTime() {
            return 10L;
        }

        @Override
        public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
            return insets;
        }

        @Override
        public WindowInsetsCompat dispatchApplyWindowInsets(View v, WindowInsetsCompat insets) {
            return insets;
        }
    }

    static interface ViewCompatImpl {
        public boolean canScrollHorizontally(View var1, int var2);

        public void postInvalidateOnAnimation(View var1);

        public void postOnAnimation(View var1, Runnable var2);

        public void setOnApplyWindowInsetsListener(View var1, OnApplyWindowInsetsListener var2);

        public WindowInsetsCompat onApplyWindowInsets(View var1, WindowInsetsCompat var2);

        public WindowInsetsCompat dispatchApplyWindowInsets(View var1, WindowInsetsCompat var2);
    }

    static interface OnApplyWindowInsetsListenerBridge {
        public Object onApplyWindowInsets(View var1, Object var2);
    }

    static interface OnApplyWindowInsetsListener {
        public WindowInsetsCompat onApplyWindowInsets(View var1, WindowInsetsCompat var2);
    }
}

