/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.baidu.mapapi.BMapManager;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapsdkplatform.comapi.commonutils.a;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BitmapDescriptorFactory {
    private static final String b = "BaiduMapSDK-" + BitmapDescriptorFactory.class.getSimpleName();

    public static BitmapDescriptor fromAsset(String string) {
        Context context = BMapManager.getContext();
        if (context == null) {
            return null;
        }
        try {
            Bitmap bitmap = com.baidu.mapsdkplatform.comapi.commonutils.a.a(string, context);
            BitmapDescriptor bitmapDescriptor = null;
            bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            assert (bitmap != null);
            bitmap.recycle();
            return bitmapDescriptor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BitmapDescriptor fromAssetWithDpi(String string) {
        Context context = BMapManager.getContext();
        if (context == null) {
            return null;
        }
        try {
            Bitmap bitmap = com.baidu.mapsdkplatform.comapi.commonutils.a.a(string, context);
            if (bitmap == null) {
                return null;
            }
            Bitmap bitmap2 = null;
            BitmapDescriptor bitmapDescriptor = null;
            int n2 = SysOSUtil.getDensityDpi();
            if (n2 > 480) {
                Matrix matrix = new Matrix();
                matrix.postScale(2.0f, 2.0f);
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap2);
            } else if (n2 > 320) {
                Matrix matrix = new Matrix();
                matrix.postScale(1.5f, 1.5f);
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap2);
            } else {
                bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            }
            bitmap.recycle();
            if (bitmap2 != null) {
                bitmap2.recycle();
            }
            return bitmapDescriptor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        return new BitmapDescriptor(bitmap);
    }

    public static BitmapDescriptor fromFile(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Context context = BMapManager.getContext();
        if (null == context) {
            return null;
        }
        try {
            FileInputStream fileInputStream = context.openFileInput(string);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream);
            fileInputStream.close();
            if (bitmap != null) {
                BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                bitmap.recycle();
                return bitmapDescriptor;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)b, (String)"FileNotFoundException happened", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Log.e((String)b, (String)"IOException happened", (Throwable)iOException);
        }
        return null;
    }

    public static BitmapDescriptor fromFileWithDpi(String string, int n2) {
        if (string == null || string.equals("")) {
            return null;
        }
        Context context = BMapManager.getContext();
        if (null == context) {
            return null;
        }
        try {
            FileInputStream fileInputStream = context.openFileInput(string);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream);
            fileInputStream.close();
            if (bitmap != null) {
                if (n2 <= 0) {
                    n2 = SysOSUtil.getDensityDpi();
                }
                bitmap.setDensity(n2);
                BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                bitmap.recycle();
                return bitmapDescriptor;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)b, (String)"FileNotFoundException happened", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Log.e((String)b, (String)"IOException happened", (Throwable)iOException);
        }
        return null;
    }

    public static BitmapDescriptor fromPath(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)string);
        if (null == bitmap) {
            return null;
        }
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        bitmap.recycle();
        return bitmapDescriptor;
    }

    public static BitmapDescriptor fromPathWithDpi(String string, int n2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)string);
        if (null == bitmap) {
            return null;
        }
        if (n2 <= 0) {
            n2 = SysOSUtil.getDensityDpi();
        }
        bitmap.setDensity(n2);
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        bitmap.recycle();
        return bitmapDescriptor;
    }

    public static BitmapDescriptor fromResource(int n2) {
        Context context = BMapManager.getContext();
        if (null == context) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
        if (bitmap == null) {
            return null;
        }
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        bitmap.recycle();
        return bitmapDescriptor;
    }

    public static BitmapDescriptor fromResourceWithDpi(int n2, int n3) {
        Context context = BMapManager.getContext();
        if (null == context) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
        if (bitmap == null) {
            return null;
        }
        if (n3 <= 0) {
            n3 = SysOSUtil.getDensityDpi();
        }
        bitmap.setDensity(n3);
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        bitmap.recycle();
        return bitmapDescriptor;
    }

    public static BitmapDescriptor fromView(View view) {
        if (view == null) {
            return null;
        }
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        if (bitmap != null) {
            bitmap.recycle();
        }
        view.destroyDrawingCache();
        return bitmapDescriptor;
    }

    public static BitmapDescriptor fromViewWithDpi(View view, int n2) {
        if (null == view) {
            return null;
        }
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        if (null == bitmap) {
            Log.e((String)b, (String)"Get bitmap failed");
            return null;
        }
        if (n2 <= 0) {
            n2 = SysOSUtil.getDensityDpi();
        }
        bitmap.setDensity(n2);
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        if (bitmap != null) {
            bitmap.recycle();
        }
        view.destroyDrawingCache();
        return bitmapDescriptor;
    }
}

