/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.graphics.Color;
import android.text.TextUtils;
import android.widget.PopupWindow;
import com.umeng.socialize.utils.ShareBoardlistener;

public class ShareBoardConfig {
    static int SHAREBOARD_POSITION_TOP = 1;
    public static int SHAREBOARD_POSITION_CENTER = 2;
    public static int SHAREBOARD_POSITION_BOTTOM = 3;
    public static int BG_SHAPE_NONE = 0;
    public static int BG_SHAPE_CIRCULAR = 1;
    public static int BG_SHAPE_ROUNDED_SQUARE = 2;
    boolean mTitleVisibility;
    String mTitleText;
    int mTitleTextColor;
    boolean mCancelBtnVisibility;
    String mCancelBtnText;
    int mCancelBtnColor;
    int mCancelBtnBgColor;
    int mCancelBtnBgPressedColor;
    int mShareboardPosition;
    int mShareboardBgColor;
    int mMenuBgShape;
    int mMenuBgShapeAngle;
    int mMenuBgColor;
    int mMenuBgPressedColor;
    int mMenuTextColor;
    int mMenuIconPressedColor;
    int mTopMargin;
    static final int CENTER_MENU_LEFT_PADDING = 36;
    static final int TITLE_TEXT_SIZE_IN_SP = 16;
    static final int TITLE_TOP_MARGIN = 20;
    static final int MENU_TOP_MARGIN = 20;
    static final int VIEW_PAGER_LEFT_MARGIN = 10;
    static final int MENU_ROW_NUM = 2;
    int mMenuColumnNum;
    private static final int MENU_COLUMN_NUM = 4;
    private static final int MENU_COLUMN_NUM_CENTER = 3;
    private static final int MENU_COLUMN_NUM_HORIZONTAL = 6;
    private static final int MENU_COLUMN_NUM_HORIZONTAL_CENTER = 5;
    static final int MENU_ROW_MARGIN = 20;
    static final int INDICATOR_BOTTOM_MARGIN = 20;
    static final int INDICATOR_SIZE = 3;
    static final int INDICATOR_SPACE = 5;
    boolean mIndicatorVisibility;
    int mIndicatorNormalColor;
    int mIndicatorSelectedColor;
    static final int CANCEL_BTN_HEIGHT = 50;
    static final int CANCEL_BTN_TEXT_SIZE_IN_SP = 15;
    private ShareBoardlistener mShareBoardlistener;
    private PopupWindow.OnDismissListener mOnDismissListener;

    public ShareBoardConfig() {
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        int n = Color.parseColor((String)"#575A5C");
        String string = "#ffffff";
        String string2 = "#22000000";
        String string3 = "#E9EFF2";
        String string4 = "\u9009\u62e9\u8981\u5206\u4eab\u5230\u7684\u5e73\u53f0";
        String string5 = "\u53d6\u6d88\u5206\u4eab";
        this.setShareboardBackgroundColor(Color.parseColor((String)string3));
        this.setShareboardPostion(SHAREBOARD_POSITION_BOTTOM);
        this.setTitleText(string4);
        this.setTitleTextColor(n);
        int n2 = 5;
        this.setMenuItemBackgroundShape(BG_SHAPE_ROUNDED_SQUARE, n2);
        this.setMenuItemBackgroundColor(Color.parseColor((String)string), Color.parseColor((String)string2));
        this.setMenuItemIconPressedColor(Color.parseColor((String)string2));
        this.setMenuItemTextColor(n);
        this.setCancelButtonText(string5);
        this.setCancelButtonTextColor(n);
        this.setCancelButtonBackground(Color.parseColor((String)string), Color.parseColor((String)string2));
        this.setIndicatorColor(Color.parseColor((String)"#C2C9CC"), Color.parseColor((String)"#0086DC"));
    }

    void setShareBoardlistener(ShareBoardlistener shareBoardlistener) {
        this.mShareBoardlistener = shareBoardlistener;
    }

    ShareBoardlistener getShareBoardlistener() {
        return this.mShareBoardlistener;
    }

    void setOrientation(boolean bl) {
        if (bl) {
            if (this.mShareboardPosition == SHAREBOARD_POSITION_BOTTOM) {
                this.mMenuColumnNum = 6;
            } else if (this.mShareboardPosition == SHAREBOARD_POSITION_CENTER) {
                this.mMenuColumnNum = 5;
            }
        } else if (this.mShareboardPosition == SHAREBOARD_POSITION_BOTTOM) {
            this.mMenuColumnNum = 4;
        } else if (this.mShareboardPosition == SHAREBOARD_POSITION_CENTER) {
            this.mMenuColumnNum = 3;
        }
    }

    public ShareBoardConfig setTitleVisibility(boolean bl) {
        this.mTitleVisibility = bl;
        return this;
    }

    public ShareBoardConfig setTitleText(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.setTitleVisibility(false);
        } else {
            this.setTitleVisibility(true);
            this.mTitleText = string;
        }
        return this;
    }

    public ShareBoardConfig setTitleTextColor(int n) {
        this.mTitleTextColor = n;
        return this;
    }

    public ShareBoardConfig setCancelButtonVisibility(boolean bl) {
        this.mCancelBtnVisibility = bl;
        return this;
    }

    public ShareBoardConfig setCancelButtonText(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.setCancelButtonVisibility(false);
        } else {
            this.setCancelButtonVisibility(true);
            this.mCancelBtnText = string;
        }
        return this;
    }

    public ShareBoardConfig setCancelButtonTextColor(int n) {
        this.mCancelBtnColor = n;
        return this;
    }

    public ShareBoardConfig setCancelButtonBackground(int n) {
        this.setCancelButtonBackground(n, 0);
        return this;
    }

    public ShareBoardConfig setCancelButtonBackground(int n, int n2) {
        this.mCancelBtnBgColor = n;
        this.mCancelBtnBgPressedColor = n2;
        return this;
    }

    public ShareBoardConfig setShareboardBackgroundColor(int n) {
        this.mShareboardBgColor = n;
        return this;
    }

    public ShareBoardConfig setShareboardPostion(int n) {
        if (n != SHAREBOARD_POSITION_BOTTOM && n != SHAREBOARD_POSITION_CENTER && n != SHAREBOARD_POSITION_TOP) {
            n = SHAREBOARD_POSITION_BOTTOM;
        }
        this.mShareboardPosition = n;
        return this;
    }

    public ShareBoardConfig setMenuItemBackgroundShape(int n) {
        this.setMenuItemBackgroundShape(n, 0);
        return this;
    }

    public ShareBoardConfig setMenuItemBackgroundShape(int n, int n2) {
        if (n != BG_SHAPE_CIRCULAR && n != BG_SHAPE_ROUNDED_SQUARE) {
            n = BG_SHAPE_NONE;
        }
        this.mMenuBgShape = n;
        this.mMenuBgShapeAngle = n2;
        return this;
    }

    public ShareBoardConfig setMenuItemBackgroundColor(int n) {
        this.setMenuItemBackgroundColor(n, 0);
        return this;
    }

    public ShareBoardConfig setMenuItemBackgroundColor(int n, int n2) {
        this.mMenuBgColor = n;
        this.mMenuBgPressedColor = n2;
        return this;
    }

    public ShareBoardConfig setMenuItemTextColor(int n) {
        this.mMenuTextColor = n;
        return this;
    }

    public ShareBoardConfig setMenuItemIconPressedColor(int n) {
        this.mMenuIconPressedColor = n;
        return this;
    }

    public ShareBoardConfig setIndicatorColor(int n) {
        this.setIndicatorColor(n, 0);
        return this;
    }

    public ShareBoardConfig setIndicatorColor(int n, int n2) {
        if (n != 0) {
            this.mIndicatorNormalColor = n;
        }
        if (n2 != 0) {
            this.mIndicatorSelectedColor = n2;
        }
        this.setIndicatorVisibility(true);
        return this;
    }

    public ShareBoardConfig setIndicatorVisibility(boolean bl) {
        this.mIndicatorVisibility = bl;
        return this;
    }

    public ShareBoardConfig setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    PopupWindow.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public ShareBoardConfig setStatusBarHeight(int n) {
        this.mTopMargin = n;
        return this;
    }

    int calculateMenuHeightInDp(int n) {
        int n2 = 75;
        int n3 = 20;
        int n4 = 20;
        int n5 = n <= this.mMenuColumnNum ? 1 : (n <= this.mMenuColumnNum * 2 ? 2 : 2);
        int n6 = n2 * n5 + n3 * (n5 - 1) + n4;
        return n6;
    }
}

