package com.rv.share.presenter;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.frame.rv.config.RvFrameConfig;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.BillActivity;
import com.rv.share.R;
import com.rv.share.view.RvWebView;
import com.rv.share.view.ShareChoiceDialog;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMWeb;

import java.io.File;

public class WebViewPresenter extends CommonPresenter {
    private ShareChoiceDialog dialog = null;
    private ShareAction shareAction = null;
    private String mUrl = null;
    private String mTitle = null;
    private String mDescript = null;
    private String mImgUrl;
    private String mCircleTitle;
    private RvWebView webView;

    public void setWebView(RvWebView webView) {
        this.webView = webView;
    }

    public void showShareDialog(String url, String imgUrl, String title, String circleTitle, String descript) {
        this.mUrl = url;
        this.mImgUrl = imgUrl;
        this.mCircleTitle = circleTitle;
        this.mTitle = title;
        this.mDescript = descript;
        if (dialog == null) {
            dialog = new ShareChoiceDialog.Builder(getPresenterContext())
                    .setShareListener(myListener)
                    .setCopyVisiable(true)
                    .setWxVisiable(true)
                    .setWxCVisiable(true)
                    .setQQVisiable(true)
                    .setBillVisiable(true)
                    .create();
        }
        dialog.show();
    }

    /******
     * 分享地址
     */
    private void shareWx() {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        UMImage image;
        if (!TextUtils.isEmpty(mImgUrl)) {
            image = new UMImage(getPresenterContext(), mImgUrl);
        } else {
            image = new UMImage(getPresenterContext(), R.drawable.icon_share);
        }
        UMWeb web = new UMWeb(mUrl);
        web.setTitle(mTitle);//标题
        web.setThumb(image);  //缩略图
        web.setDescription(mDescript);//描述

        shareAction.setPlatform(SHARE_MEDIA.WEIXIN)//传入平台
                .withMedia(web);
        shareAction.share();

    }

    /******
     * 分享地址
     */
    private void shareWxC() {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }

        UMImage image;
        if (!TextUtils.isEmpty(mImgUrl)) {
            image = new UMImage(getPresenterContext(), mImgUrl);
        } else {
            image = new UMImage(getPresenterContext(), R.drawable.icon_share);
        }
        UMWeb web = new UMWeb(mUrl);
        web.setTitle(TextUtils.isEmpty(mCircleTitle) ? mTitle : mCircleTitle);//标题
        web.setThumb(image);  //缩略图
        shareAction.setPlatform(SHARE_MEDIA.WEIXIN_CIRCLE)//传入平台
                .withMedia(web);
        shareAction.share();
    }


    /******
     * 分享文件
     * @param var1
     * @param var2
     */
    private void shareQQ(SHARE_MEDIA var1, String var2) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(var2);//分享内容
        shareAction.share();
    }


    /*******
     * 复制地址
     * @param url
     */
    private void copy(String url) {
        ClipboardManager cm = (ClipboardManager) getPresenterContext().getSystemService(Context.CLIPBOARD_SERVICE);
        ClipData mClipData = ClipData.newRawUri("Label", Uri.parse(url));
        cm.setPrimaryClip(mClipData);
        Toast.makeText(getPresenterContext(), "复制成功", Toast.LENGTH_SHORT).show();
    }

    private UMShareListener shareListener = new UMShareListener() {
        @Override
        public void onStart(SHARE_MEDIA share_media) {
            if (webView != null) {
                webView.loadUrl("javascript:shareSuccess()");
            }
        }

        @Override
        public void onResult(SHARE_MEDIA share_media) {
//            if (webView != null) {
//                webView.loadUrl("javascript:shareSuccess()");
//            }
        }

        @Override
        public void onError(SHARE_MEDIA share_media, Throwable throwable) {
            Log.e("xxxxxxxxxx", "shareonError:" + throwable.getMessage());
        }

        @Override
        public void onCancel(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareonCancel");
        }
    };

    private ShareChoiceDialog.ShareListener myListener = new ShareChoiceDialog.ShareListener() {
        @Override
        public void copyShare() {
            if (!TextUtils.isEmpty(mUrl)) {
                copy(mUrl);
            }
        }

        @Override
        public void wxShare() {
            if (!TextUtils.isEmpty(mUrl))
                shareWx();
        }

        @Override
        public void wxCShare() {
            if (!TextUtils.isEmpty(mUrl))
                shareWxC();
        }

        @Override
        public void qqShare() {
            if (!TextUtil.isEmpty(mUrl)) {
                shareQQ(SHARE_MEDIA.QQ, mUrl);
            }
        }

        @Override
        public void billShare() {
            String billUrl = RvFrameConfig.HOST + "/h5/appHtml/view/poster.html";
//            String billUrl = "https://xxtest.upyuns.com/h5/appHtml/view/poster.html" ;
            getPresenterContext().startActivity(BillActivity.getIntent(getPresenterContext(), billUrl));
        }

        @Override
        public void close() {
        }
    };
}
