package com.rv.share.fragment;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.google.gson.Gson;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.R;
import com.rv.share.R2;
import com.rv.share.adapter.IncomeListAdapter;
import com.rv.share.bean.IncomeRecordsBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;

public class InComeRecordFragment extends BaseFragment<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout refreshLayout;

    private IncomeListAdapter adapter;

    private int currentPage = 1;
    private int pageSize = 10;
    private int pageTotal = 0;

    public static InComeRecordFragment getInstance() {
        InComeRecordFragment fragment = new InComeRecordFragment();
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_income_record;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext(), LinearLayout.VERTICAL, false));
        adapter = new IncomeListAdapter(new ArrayList<IncomeRecordsBean.IncomeItem>());
        adapter.setOnLoadMoreListener(this, recyclerView);
        refreshLayout.setHeaderView(new SimpleRefreshView(getContext()));
        refreshLayout.setOnSimpleRefreshListener(this);
        recyclerView.setAdapter(adapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {
        getIncomeData();
    }

    private void getIncomeData() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> map = new HashMap<>();
            map.put("pageNo", currentPage);
            map.put("pageSize", pageSize);
            mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_INCOME_RECORD, IncomeRecordsBean.class, map, header, true);
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            IncomeRecordsBean bean = (IncomeRecordsBean) result;
            if (bean.isRel() && bean.getData() != null && bean.getData().getSellingWaters() != null) {
                if (currentPage == 1) {
                    pageTotal = bean.getData().getTotalPage();
                    adapter.setNewData(bean.getData().getSellingWaters());
                    refreshLayout.onRefreshComplete();
                    if (bean.getData().getSellingWaters().size() == 0) {
                        adapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.rv_select_not_data)));
                        adapter.notifyDataSetChanged();
                    }
                } else {
                    adapter.addData(bean.getData().getSellingWaters());
                    adapter.loadMoreComplete();
                }
            }
        }
    }

    @Override
    public void onLoadMoreRequested() {

        if (currentPage >= pageTotal) {
            adapter.loadMoreEnd();
        } else {
            currentPage++;
            getIncomeData();
        }
    }

    @Override
    public void onRefresh() {
        currentPage = 1;
        getIncomeData();
    }
}
