package com.rv.share;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.base.utils.ui.image.round.RoundImageView;
import com.ruiwenliu.wrapper.SPConstance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.bean.UserInfoBean;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.DisplayUtil;
import com.rv.component.utils.RvCache;
import com.rv.component.utils.ZxingUtils;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.share.presenter.ReativeBillPresenter;
import com.yuyife.okgo.OkGoUtil;

import butterknife.BindView;
import butterknife.OnClick;

public class ReativeBillActivity extends BaseStatusActivity<ReativeBillPresenter> {

    private String url;
    @BindView(R2.id.ring_header)
    RoundImageView roundImageView;
    @BindView(R2.id.tv_phone)
    TextView tvPhone;
    @BindView(R2.id.img_qrcode)
    ImageView imgQrcode;
    @BindView(R2.id.btn_save_bill)
    Button btnSaveBill;
    @BindView(R2.id.btn_share)
    Button btnShare;
    @BindView(R2.id.ll_bill_content)
    CardView llBillContent;
//    @BindView(R2.id.ll_content)
//    LinearLayout llContent;

    public static Intent getIntent(Context context, String url) {
        Intent intent = new Intent(context, ReativeBillActivity.class);
        intent.putExtra("url", url);
        return intent;
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_reative_bill;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setVisibility(View.GONE);
        url = intent.getStringExtra("url");
        if (!TextUtils.isEmpty(url)) {
            Bitmap bitmap = ZxingUtils.createQRImage(url, DisplayUtil.dip2px(this, 150), DisplayUtil.dip2px(this, 150), BitmapFactory.decodeResource(getResources(), com.rv.home.R.mipmap.ic_launcher));

            imgQrcode.setImageBitmap(bitmap);
        }

        UserInfoBean userInfoBean = (UserInfoBean) RvCache.getInstance(getApplicationContext()).get(CacheEnum.USER);

        String name = userInfoBean.getData().getNickname();
        String url = userInfoBean.getData().getHeadimgurl();
        if (!TextUtils.isEmpty(url)) {
            GlideManager.getInstance(getApplicationContext()).loadImage3(url, roundImageView);
        }
        if (!TextUtils.isEmpty(name)) {
            tvPhone.setText(name);
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.btn_save_bill, R2.id.btn_share, R2.id.tv_back_title})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.tv_back_title) {
            finish();
        } else if (id == R.id.btn_save_bill) {
            preShare(0, 1001);
        } else if (id == R.id.btn_share) {
            preShare(1, 1002);
        }
    }

    /**
     * 预备下载 进行 6.0权限检查
     */
    private void preShare(int type, int requestCode) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            if (type == 0) {
                mPresenter.saveBill(llBillContent);
            } else {
                mPresenter.share(llBillContent);
            }
        } else {
            if (ContextCompat.checkSelfPermission(this,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED) {
                if (type == 0) {
                    mPresenter.saveBill(llBillContent);
                } else {
                    mPresenter.share(llBillContent);
                }
            } else {//申请权限
                ActivityCompat.requestPermissions(this,
                        new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, requestCode);
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1001:
                if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    mPresenter.saveBill(llBillContent);
                } else {
                    Toast.makeText(getApplicationContext(), "授权失败,无法分享海报", Toast.LENGTH_SHORT).show();
                }
                break;
            case 1002:
                if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    mPresenter.share(llBillContent);
                } else {
                    Toast.makeText(getApplicationContext(), "授权失败,无法分享海报", Toast.LENGTH_SHORT).show();
                }
                break;
        }
    }


}
