package com.rv.rvmine.traveler;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.StringUtils;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;
import com.rv.rvmine.bean.AddTraveler;
import com.rv.rvmine.bean.TravelerListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 添加出游人
 */
public class AddAVisitorActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.cb_adult)
    CheckBox cbAdult;
    @BindView(R2.id.cb_child)
    CheckBox cbChild;
    @BindView(R2.id.et_traveler_name)
    EditText etTravelerName;
    @BindView(R2.id.cb_man)
    CheckBox cbMan;
    @BindView(R2.id.cb_girl)
    CheckBox cbGirl;
    @BindView(R2.id.et_id_card)
    EditText etIdCard;
    @BindView(R2.id.et_phone)
    EditText etPhone;

    private int identityType = 0;
    private int sexType = 1;
    private int avisitorId;

    public static Intent getIntent(Context context, TravelerListBean.DataBean bean) {
        return new Intent(context, AddAVisitorActivity.class).putExtra("bean", bean);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_add_avisitor;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        TravelerListBean.DataBean dataBean = (TravelerListBean.DataBean) intent.getSerializableExtra("bean");
        if (dataBean != null) {
            titleView.setTitle("编辑出游人");
            avisitorId = dataBean.getId();
            identityType = dataBean.getIsChild();
            sexType = dataBean.getSex();
            if (0 == dataBean.getIsChild()) {
                cbAdult.setChecked(true);
                cbChild.setChecked(false);
            } else {
                cbAdult.setChecked(false);
                cbChild.setChecked(true);
            }
            if (0 == dataBean.getSex()) {
                cbMan.setChecked(false);
                cbGirl.setChecked(true);
            } else {
                cbMan.setChecked(true);
                cbGirl.setChecked(false);
            }
            etTravelerName.setText(dataBean.getName());
            etIdCard.setText(dataBean.getIdCard());
            etPhone.setText(dataBean.getPhone());

        } else {
            titleView.setTitle(getString(R.string.add_a_visitor_title));
        }


        titleView.setText(R.id.tv_title_right, getString(R.string.rv_save));
        titleView.setChildClickListener(R.id.tv_title_right, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String name = etTravelerName.getText().toString().trim();
                if (TextUtil.isEmpty(name)) {
                    showToast("姓名不能为空！");
                    return;
                }
                String idCard = null, phone = null;
                idCard = etIdCard.getText().toString().trim();
                if (TextUtil.isEmpty(idCard) || idCard.length() != 18) {
                    showToast("请输入正确的身份证号码！");
                    return;
                }

                if (identityType == 0) {
                    phone = etPhone.getText().toString().trim();

                    if (!StringUtils.isChinaPhone(phone)) {
                        showToast("请输入正确的手机号码！");
                        return;
                    }
                }
                addAVisitor(name, idCard, phone);
            }
        });
    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {
        TravelerListBean.DataBean addBean = new TravelerListBean.DataBean();
        setResult(RESULT_OK);
        finish();
    }

    @OnClick({R2.id.cb_adult, R2.id.cb_child, R2.id.cb_man, R2.id.cb_girl})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.cb_adult) {
            //成人
            cbAdult.setChecked(true);
            cbChild.setChecked(false);
            identityType = 0;
        } else if (id == R.id.cb_child) {
            //儿童
            cbAdult.setChecked(false);
            cbChild.setChecked(true);
            identityType = 1;
        } else if (id == R.id.cb_man) {
            //男
            cbMan.setChecked(true);
            cbGirl.setChecked(false);
            sexType = 1;
        } else if (id == R.id.cb_girl) {
            //女
            cbMan.setChecked(false);
            cbGirl.setChecked(true);
            sexType = 0;
        }
    }


    /**
     * 编辑或修改出游人信息
     *
     * @param name
     * @param idCard
     * @param phone
     */
    private void addAVisitor(String name, String idCard, String phone) {

        mPresenter.postBodyData(RvFrameConfig.VEHICLE_TOURUSER, 0, ApiConfig.HTTP_URL_ADDANDUPDATE, BaseBean.class, new AddTraveler(avisitorId == 0 ? null : avisitorId, name, sexType, phone, idCard, identityType), getHeadMap(), true);
    }

    @Override
    public void onShowError(String errorMsg, int errorType) {
        if (!TextUtils.isEmpty(errorMsg)) {
            showToast(errorMsg);
        }
    }

    private Map<String, Object> getHeadMap() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        return headMap;
    }

}
