package com.xxfc.discovery.popupwindow;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.dialog.BasePopupWindow;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.xxfc.discovery.R;

/**
 * 发现增加功能
 */
public class AddDiscoveryContentPw extends BasePopupWindow {

    public AddDiscoveryContentPw(@NonNull Activity context) {
        super(context);
        setOutsideTouchable(true);
        setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
        setWidth(ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    @Override
    public int getViewLayout() {
        return R.layout.pop_add_discovery_content;
    }

    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);
//        //拍拍
//        helper.setOnClickListener(R.id.tv_pat, new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                dismiss();
//            }
//        });
//
//        //短视频
//        helper.setOnClickListener(R.id.tv_short_video, new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                dismiss();
//            }
//        });
//
//        //去提问
//        helper.setOnClickListener(R.id.tv_ask_questions, new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//
//            }
//        });
    }

    /**
     * @param anchor v
     */
    public void showPopupWindow(final View anchor) {
        if (Build.VERSION.SDK_INT >= 24) {
            Rect visibleFrame = new Rect();
            anchor.getGlobalVisibleRect(visibleFrame);
//            int height = anchor.getResources().getDisplayMetrics().heightPixels - visibleFrame.bottom;
//            this.setHeight(height);
            this.showAsDropDown(anchor, -170, 0);
        } else {
            this.showAsDropDown(anchor, -170, 0);
        }
    }


    private void fullScreenImmersive(View view) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            int uiOptions = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_FULLSCREEN;
            view.setSystemUiVisibility(uiOptions);
        }
    }
}
