package com.xxfc.rv;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;

import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.statusbar.StatusBarUtil;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.LogUtil;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.yuyife.okgo.OkGoUtil;

import java.util.concurrent.TimeUnit;

import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public class WelcomeActivity extends BaseActivity<CommonPresenter> {
    private Disposable mDisposable = null;

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected int setLayout() {
        return R.layout.rv_act_weclome;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);//隐藏菜单栏
        interval();

        LogUtil.d("start");

    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        stopCarousel();
    }

    /**
     * 计时器
     */
    private void interval() {
        mDisposable = Flowable.interval(2, TimeUnit.SECONDS)
                .doOnNext(new Consumer<Long>() {
                    @Override
                    public void accept(@NonNull Long aLong) throws Exception {
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Consumer<Long>() {
                    @Override
                    public void accept(@NonNull Long aLong) {
                        try {
                            if (!TextUtils.isEmpty(UtilsManager.getInstance(mActivity).getSPInstance("city_json").getString("token", ""))) {
                                OkGoUtil.setToken(
                                        UtilsManager.getInstance(mActivity)
                                                .getSPInstance("city_json")
                                                .getString("token", ""));
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        startActivity(MainActivity.getIntent(mActivity));
                        mDisposable.dispose();
                        finish();
                    }
                });

    }

    /**
     * 停止计时
     */
    public void stopCarousel() {
        if (mDisposable != null && !mDisposable.isDisposed()) {
            mDisposable.dispose();
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_FULLSCREEN);
    }
}
