/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.editorpage.IEditor;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.net.analytics.AnalyticsReqeust;
import com.umeng.socialize.net.analytics.AnalyticsResponse;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;
import java.util.Map;
import java.util.Stack;

public abstract class UMAPIShareHandler
extends UMSSOHandler
implements IEditor {
    private Stack<StatHolder> mStatStack = new Stack();

    @Override
    public void onCreate(Context context, PlatformConfig.Platform platform) {
        super.onCreate(context, platform);
    }

    public abstract String getUID();

    public abstract SHARE_MEDIA getPlatform();

    public abstract void authorizeCallBack(int var1, int var2, Intent var3);

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
        if (n != this.getRequestCode()) {
            return;
        }
        if (n2 == 1000) {
            StatHolder statHolder;
            if (!this.mStatStack.isEmpty() && (statHolder = this.mStatStack.pop()) != null) {
                statHolder.Listener.onCancel(this.getPlatform());
            }
        } else if (intent != null && intent.hasExtra("txt")) {
            if (!this.mStatStack.empty()) {
                final StatHolder statHolder = this.mStatStack.pop();
                final Bundle bundle = intent.getExtras();
                if (n2 == -1) {
                    QueuedWork.runInBack(new Runnable(){

                        @Override
                        public void run() {
                            ShareContent shareContent = UMAPIShareHandler.this.getResult(statHolder.Content, bundle);
                            UMAPIShareHandler.this.sendShareRequest(shareContent, statHolder.Listener);
                        }
                    }, true);
                } else if (statHolder.Listener != null) {
                    statHolder.Listener.onCancel(this.getPlatform());
                }
            }
        } else {
            this.authorizeCallBack(n, n2, intent);
        }
    }

    public abstract void deleteAuth();

    @Override
    public boolean share(final ShareContent shareContent, final UMShareListener uMShareListener) {
        if (this.isAuthorize()) {
            this.doShare(shareContent, uMShareListener);
        } else {
            this.authorize(new UMAuthListener(){

                @Override
                public void onStart(SHARE_MEDIA sHARE_MEDIA) {
                    uMShareListener.onStart(sHARE_MEDIA);
                }

                @Override
                public void onComplete(SHARE_MEDIA sHARE_MEDIA, int n, Map<String, String> map) {
                    QueuedWork.runInBack(new Runnable(){

                        @Override
                        public void run() {
                            UMAPIShareHandler.this.doShare(shareContent, uMShareListener);
                        }
                    }, true);
                }

                @Override
                public void onError(SHARE_MEDIA sHARE_MEDIA, int n, Throwable throwable) {
                    uMShareListener.onError(sHARE_MEDIA, throwable);
                }

                @Override
                public void onCancel(SHARE_MEDIA sHARE_MEDIA, int n) {
                    uMShareListener.onCancel(sHARE_MEDIA);
                }
            });
        }
        return false;
    }

    protected void doShare(ShareContent shareContent, UMShareListener uMShareListener) {
        if (this.getShareConfig().isOpenShareEditActivity()) {
            StatHolder statHolder = new StatHolder();
            statHolder.Content = shareContent;
            statHolder.Listener = uMShareListener;
            this.mStatStack.push(statHolder);
            if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                try {
                    Class<?> clazz = Class.forName("com.umeng.socialize.editorpage.ShareActivity");
                    Intent intent = new Intent((Context)this.mWeakAct.get(), clazz);
                    intent.putExtras(this.getEditable(shareContent));
                    ((Activity)this.mWeakAct.get()).startActivityForResult(intent, this.getRequestCode());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.sendShareRequest(shareContent, uMShareListener);
                    SLog.error(UmengText.INTER.NULLJAR, classNotFoundException);
                    classNotFoundException.printStackTrace();
                }
            }
        } else {
            this.sendShareRequest(shareContent, uMShareListener);
        }
    }

    public void sendShareRequest(final ShareContent shareContent, final UMShareListener uMShareListener) {
        AnalyticsResponse analyticsResponse;
        final SHARE_MEDIA sHARE_MEDIA = this.getPlatform();
        String string = sHARE_MEDIA.toString().toLowerCase();
        String string2 = this.getUID();
        AnalyticsReqeust analyticsReqeust = new AnalyticsReqeust(this.getContext(), string, shareContent.mText);
        analyticsReqeust.setMedia(shareContent.mMedia);
        analyticsReqeust.setmUsid(string2);
        analyticsReqeust.setReqType(0);
        final AnalyticsResponse analyticsResponse2 = analyticsResponse = RestAPI.doShareByRequest(analyticsReqeust);
        if (analyticsResponse == null) {
            QueuedWork.runInMain(new Runnable(){

                @Override
                public void run() {
                    uMShareListener.onError(sHARE_MEDIA, new Throwable(UmengErrorCode.ShareFailed.getMessage() + "response is null"));
                }
            });
        } else if (!analyticsResponse.isOk()) {
            QueuedWork.runInMain(new Runnable(){

                @Override
                public void run() {
                    if (analyticsResponse.mStCode == 5027) {
                        UMAPIShareHandler.this.deleteAuth();
                        UMAPIShareHandler.this.share(shareContent, uMShareListener);
                    } else {
                        uMShareListener.onError(sHARE_MEDIA, new Throwable(UmengErrorCode.ShareFailed.getMessage() + analyticsResponse2.mMsg));
                    }
                }
            });
        } else {
            QueuedWork.runInMain(new Runnable(){

                @Override
                public void run() {
                    uMShareListener.onResult(sHARE_MEDIA);
                }
            });
        }
    }

    private static class StatHolder {
        public ShareContent Content;
        private UMShareListener Listener;

        private StatHolder() {
        }
    }
}

