package com.xxrv.coupon.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.xxrv.coupon.R;
import com.xxrv.coupon.bean.CouponBean;

/**
 *  优惠券  已过期
 */

public class ExpiredCouponAdapter extends BaseQuickAdapter<CouponBean.DataBean, BaseViewHolder> {

    public ExpiredCouponAdapter() {
        super(R.layout.rv_item_expiredcoupon);
    }

    @Override
    protected void convert(BaseViewHolder helper, CouponBean.DataBean item) {
        if (item !=null){
            helper.setText(R.id.tv_name,item.getTitle());
            helper.setText(R.id.tv_type,item.getSubtitle());
            helper.setText(R.id.tv_date,"有效期至" + DateUtils.timestampToString2(item.getExpireTime()));
            helper.setText(R.id.tv_amount,String.valueOf(item.getUsedAmount()));
            if ("1".equals(item.getType())){  //1满减券 2叠加满减券 3无门槛券
                helper.setText(R.id.tv_condition,"满"+item.getWithAmount()+"减"+item.getUsedAmount()+"元");
            }else if ("3".equals(item.getType())){
                helper.setText(R.id.tv_condition,"无门槛");
            }

        }
    }
}
