package com.rv.rvmine.traveler;

import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;

import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.bean.HomeRecommendBean;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;
import com.rv.rvmine.adapter.MyReleasePatAdapter;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

/**
 * 我的发布
 */
public class MyReleaseActivity extends BaseStatusActivity<CommonPresenter> implements SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;
    private int countPage;
    private int mPage;

    private MyReleasePatAdapter mAdapter;

    public static Intent getIntent(Context context) {
        return new Intent(context, MyReleaseActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_my_release;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("我的发布");
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(mActivity));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);

        mAdapter = new MyReleasePatAdapter();

        final StaggeredGridLayoutManager staggeredGridLayoutManager = new StaggeredGridLayoutManager(2, StaggeredGridLayoutManager.VERTICAL);
        rvContent.setItemAnimator(null);
        rvContent.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                int[] first = new int[2];
                staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(first);
                if (newState == RecyclerView.SCROLL_STATE_IDLE && (first[0] == 1 || first[1] == 1)) {
                    recyclerView.invalidateItemDecorations();
                }
            }
        });

        rvContent.setLayoutManager(staggeredGridLayoutManager);
        rvContent.addItemDecoration(new AbSpacesItemDecoration(20, 10));// 分割线。
        rvContent.setAdapter(mAdapter);
        mAdapter.bindToRecyclerView(rvContent);
        mAdapter.setEnableLoadMore(true);
        mAdapter.disableLoadMoreIfNotFullPage();

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                HomeRecommendBean.DataBeanX.DataBean item = (HomeRecommendBean.DataBeanX.DataBean) adapter.getItem(position);
                if (item != null) {
                    ARouter.getInstance()
                            .build(Constance.ACTIVITY_URL_DETAILPAT)
                            .withString("id", item.getMsgId())
                            .withString("title",item.getBody().getText())
                            .withString("iconUrl",item.getBody().getImages().get(0).getOurl())
                            .withString("userName",item.getNickname())
                            .withString("userUrl",item.getPicUrl())
                            .navigation();
                }
            }
        });


        mAdapter.setOnLoadMoreListener(new BaseQuickAdapter.RequestLoadMoreListener() {
            @Override
            public void onLoadMoreRequested() {
                if (rvContent != null) {
                    rvContent.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (mPage >= countPage) {
                                mAdapter.loadMoreEnd();
                            } else {
                                mPage++;
                                geDataList(mPage);
                            }
                        }
                    }, 200);
                }
            }
        }, rvContent);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        onFresh();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        mSimpleRefreshLayout.onRefreshComplete();
        switch (requestType) {
            case 0:
                processData((HomeRecommendBean) result);
                break;

        }
    }

    private void processData(HomeRecommendBean bean) {
        if (mPage == 1) {
            countPage = bean.getData().getPageSize();
            mAdapter.setNewData(bean.getData().getList());
            if (bean.getData().getTotalCount() == 0) {
                mAdapter.setEmptyView(getEmptyView(rvContent, -1, "暂无发布的数据"));
                mAdapter.notifyDataSetChanged();
            }
        } else {
            mAdapter.addData(bean.getData().getList());
            mAdapter.loadMoreComplete();
        }
    }

    @Override
    public void onRefresh() {
        onFresh();
    }

    /**
     * 刷新
     */
    private void onFresh() {
        mPage = 1;
        geDataList(mPage);
    }

    /**
     * 请求数据
     *
     * @param page
     */
    private void geDataList(int page) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null) {
            headMap.put("Authorization", OkGoUtil.getToken());
        }
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("page", page);
        mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.RVENTHUSIAST_GETBYUSERID_LIST, HomeRecommendBean.class, map, headMap, page == 1 ? true : false);
    }

    public class AbSpacesItemDecoration extends RecyclerView.ItemDecoration {

        private int left;
        private int right;

        public AbSpacesItemDecoration(int left, int right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int position = parent.getChildAdapterPosition(view);
            StaggeredGridLayoutManager.LayoutParams lp = (StaggeredGridLayoutManager.LayoutParams) view.getLayoutParams();

            if (lp.getSpanIndex() % 2 == 0) {
                outRect.left = left;
                outRect.right = right;
            } else {
                outRect.left = right;
                outRect.right = left;
            }
            outRect.top = left;
        }
    }
}
