package com.rv.rvmine.personal;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.TextView;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.Inc;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;

import butterknife.BindView;

/**
 * 身份证认证显示
 */
public class IDCardCertificationShowActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.tv_name)
    TextView tvName;
    @BindView(R2.id.tv_idcard)
    TextView tvIdcard;

    public static Intent getIntent(Context context, String name, String idcard) {
        return new Intent(context, IDCardCertificationShowActivity.class)
                .putExtra("name", name)
                .putExtra("idcard", idcard);
    }


    @Override
    protected int setLayout() {
        return R.layout.activity_idcard_certification_show;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("身份证认证");
        tvName.setText(intent.getStringExtra("name"));
        String idcard = intent.getStringExtra("idcard");
        if (!TextUtils.isEmpty(idcard)) {
            tvIdcard.setText(Inc.settingID(idcard));
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

}
