package com.rv.rvmine.adapter;

import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.rvmine.R;
import com.rv.rvmine.bean.TravelerListBean;

import java.util.ArrayList;
import java.util.List;

/**
 * Desc:出游人列表
 */

public class TravelerListAdapter extends BaseQuickAdapter<TravelerListBean.DataBean, BaseViewHolder> {

    private int openType;
    private SelectListener mListener = null;

    public TravelerListAdapter(int openType, SelectListener listener) {
        super(R.layout.rv_item_traveler_list);
        this.openType = openType;
        this.mListener = listener;
    }

    @Override
    protected void convert(final BaseViewHolder helper, final TravelerListBean.DataBean item) {
        helper.setText(R.id.tv_name, item.getName());
        helper.setText(R.id.tv_phone, item.getPhone());
        helper.setText(R.id.tv_travel_type, item.getIsChild() == 0 ? "(成人)" : "(儿童)");
        helper.setText(R.id.tv_id_card, item.getIdCard());
        helper.addOnClickListener(R.id.tv_edit);
        if (openType == 0) {
            helper.itemView.findViewById(R.id.cb_draveler).setVisibility(View.GONE);
        } else {
            if (item.getStatus()) {
                helper.setImageResource(R.id.cb_draveler, R.drawable.common_icon_select);
            } else {
                helper.setImageResource(R.id.cb_draveler, R.drawable.common_icon_unselect);
            }

            helper.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    boolean status = item.getStatus();
                    boolean result = false;
                    if (mListener != null) {
                        result = mListener.select(item, status ? 0 : 1);
                    }
                    if (result) { // 动作成功
                        status = !status;
                        item.setStatus(status);
                    } else {
                        mListener.showError();
                    }
                    helper.setImageResource(R.id.cb_draveler, status ? R.drawable.common_icon_select :  R.drawable.common_icon_unselect);
                }
            });
        }
    }

    public int getPosition(TravelerListBean.DataBean item) {
        return mData.indexOf(item);
    }

    /**
     * 获取选中的出游人数据
     *
     * @return
     */
    public List<TravelerListBean.DataBean> getSelectItem() {
        List<TravelerListBean.DataBean> list = new ArrayList<>();
        for (TravelerListBean.DataBean dataBean : mData) {
            if (dataBean.getStatus()) {
                list.add(dataBean);
            }
        }
        return list;
    }

    public interface SelectListener {

        /*****
         *
         * @param bean
         * @param action 0 取消选中；1 选中
         * @return
         */
        boolean select(TravelerListBean.DataBean bean, int action);

        void showError();
    }

}
