package com.rv.rvmine.adapter;

import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.ruiwenliu.wrapper.util.TransformationUtil;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.rv.home.rv.module.ui.main.home.bean.HomeRecommendBean;
import com.rv.rvmine.R;

public class MyReleasePatAdapter extends BaseQuickAdapter<HomeRecommendBean.DataBeanX.DataBean, BaseGlideHolder> {

    public MyReleasePatAdapter() {
        super(R.layout.rv_item_rv_release_pat);
    }

    @Override
    protected void convert(BaseGlideHolder helper, HomeRecommendBean.DataBeanX.DataBean item) {
        HomeRecommendBean.DataBeanX.DataBean.Body body = item.getBody();
        if (body != null) {
            if (body.getImages() != null && body.getImages().size() > 0) {

//                GlideManager.getInstance(mContext).loadRoundImage2(body.getImages().get(0).getOurl(), (ImageView) helper.getView(R.id.iv_icon_pat),8);

                ImageView image = helper.getView(R.id.iv_icon_pat);
                GlideOptions options = GlideOptions.placeholderOf(com.ruiwenliu.wrapper.R.drawable.glide_icon_placeholder).
                        error(com.ruiwenliu.wrapper.R.drawable.glide_icon_error);
                TransformationUtil utils = new TransformationUtil(image);
                Glide.with(mContext)
                        .asBitmap()
                        .load(body.getImages().get(0).getOurl())
                        .apply(options)
                        .apply(RequestOptions.bitmapTransform(new RoundedCorners(12)).override(image.getWidth(), image.getHeight()))
                        .into(utils);
            }

            helper.setText(R.id.tv_title, body.getText());
//            helper.setText(R.id.tv_address, body);
            if ("4".equals(body.getType())) { //消息类型 基础属性 1=文字消息、2=图文消息、3=语音消息、4=视频消息、 5=文件消
                helper.setGone(R.id.iv_isvideo, true);
            } else {
                helper.setGone(R.id.iv_isvideo, false);
            }
        }
    }
}
