package com.rv.home.rv.module.ui.main.home.adapter;

import android.support.v4.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.home.R;
import com.rv.home.R2;

/**
 * Created :Auser
 * Date: 2019/5/28.
 * Desc:订单菜单
 */

public class OrderMenuAdapter extends BaseQuickAdapter<String, BaseViewHolder> {

    public OrderMenuAdapter() {
        super(R.layout.rv_item_horizontal);
    }

    private int selectPosition;

    @Override
    protected void convert(BaseViewHolder helper, String item) {
        helper.setText(R.id.tv_title, item);
        if (selectPosition == getPosition(item)) {

            helper.setTextColor(R.id.tv_title, ContextCompat.getColor(mContext, R.color.gray_FFB74B));
            helper.setGone(R.id.view_line, true);
        } else {
            helper.setTextColor(R.id.tv_title, ContextCompat.getColor(mContext, R.color.textMain));
            helper.setGone(R.id.view_line, false);
        }
    }

    public int getPosition(String item) {
        return mData.indexOf(item);
    }

    public void setSelectItem(int position) {
        this.selectPosition = position;
        notifyDataSetChanged();
    }

    /**
     * 获取选中的菜单
     *
     * @return
     */
    public int getSelectPosition() {
        return selectPosition;
    }
}
