package com.base.utils.tools.android;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.DisplayMetrics;

import java.util.Locale;

/**
 * 语言地区工具
 */

public class LanguageUtil {

    /**
     * 默认是中文
     * 初始化语言  step 1
     */
    public static void setAppLanguage(Context context) {

        //初始化PreferenceUtil
        if (null == SPUtil.getAppLanguageString(context) || TextUtils.isEmpty(SPUtil.getAppLanguageString(context))) {
            String language = Locale.getDefault().getLanguage();
            if (language.equals(SPUtil.APP_LANGUAGE_ZH)) {
                //当前语言是中文
                switchAppLanguage(context,SPUtil.APP_LANGUAGE_ZH);
            } else if (language.equals(SPUtil.APP_LANGUAGE_EN)) {
                //当前语言是英文
                switchAppLanguage(context,SPUtil.APP_LANGUAGE_EN);
            } else {
                //当前语言是其他 
                switchAppLanguage(context,SPUtil.APP_LANGUAGE_ZH);
            }
        } else {
            //根据上次的语言设置，重新设置语言
            switchAppLanguage(context,SPUtil.getAppLanguageString(context));
        }
    }

    /**
     * 切换语言  step 2
     *
     * @param language
     */
    public static void switchAppLanguage(Context context,String language) {
        //设置应用语言类型
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        DisplayMetrics dm = resources.getDisplayMetrics();
        if (language != null) {

            if (language.equals(SPUtil.APP_LANGUAGE_EN)) {
                config.locale = Locale.ENGLISH;
                SPUtil.setAppLanguageEnglish(context);

            } else  if (language.equals(SPUtil.APP_LANGUAGE_ZH)){
                config.locale = Locale.SIMPLIFIED_CHINESE;
                SPUtil.setAppLanguageChinese(context);

            }else {
                config.locale = Locale.SIMPLIFIED_CHINESE;
                SPUtil.setAppLanguageChinese(context);

            }
            resources.updateConfiguration(config, dm);
            //保存设置语言的类型
            //SPUtil.setAppLanguageString(context, language);
        }

    }

}
