package com.ruiwenliu.wrapper.presenter;


import android.util.Log;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseView;
import com.ruiwenliu.wrapper.http.HttpApi;
import com.ruiwenliu.wrapper.http.RxRequestResult;
import com.ruiwenliu.wrapper.http.RxRequestResult2;

import java.util.Map;
import java.util.Observable;

import io.reactivex.Flowable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subscribers.DisposableSubscriber;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Response;

/**
 * Created by Amuse
 * Data:2019/1/11 0011
 * Desc:
 */

public abstract class MvpPresenter<V extends BaseView> extends RetrofitPresenter<V> {

    /**
     * get请求
     *
     * @param position 请求序列号
     * @param url      地址
     * @param bean     请求实体类
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getData(int position, String url, Class<T> bean, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 111111111111111111111");
        }
        toSubscribe(getApi().rxGet(url), new RxRequestResult<>(position, bean, getView()), position);
    }

    /**
     * get请求
     *
     * @param position
     * @param url
     * @param bean
     * @param objectMap
     * @param isShow    是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getData(int position, String url, Class<T> bean, Map<String, Object> objectMap, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 222222222222222222222222");
        }
        toSubscribe(getApi().rxGet(url, objectMap), new RxRequestResult<>(position, bean, getView()), position);
    }

    /**
     * 自定义域名get请求
     *
     * @param baseUrl   域名地址
     * @param position
     * @param url
     * @param bean
     * @param objectMap
     * @param isShow    是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getData(String baseUrl, int position, String url, Class<T> bean, Map<String, Object> objectMap, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 3333333333333333333333333");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxGet(url, objectMap), new RxRequestResult<>(position, bean, getView()), position);
    }


    /**
     * 自定义域名get请求
     *
     * @param baseUrl  域名地址
     * @param position
     * @param url
     * @param bean
     * @param headMap
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getDataHead(String baseUrl, int position, String url, Class<T> bean, Map<String, Object> headMap, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 444444444444444444444444444444");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxGetHead(url, headMap), new RxRequestResult<>(position, bean, getView()), position);
    }

    /**
     * 自定义域名get请求
     *
     * @param baseUrl   域名地址
     * @param position
     * @param url
     * @param bean
     * @param objectMap
     * @param isShow    是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getData(String baseUrl, int position, String url, Class<T> bean, Map<String, Object> objectMap, Map<String, Object> headMap, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 5555555555555555555555555555555555");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxGet(url, objectMap, headMap), new RxRequestResult<>(position, bean, getView()), position);
    }

    /**
     * 自定义域名get请求
     *
     * @param baseUrl  域名地址
     * @param position
     * @param url
     * @param bean
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getData(String baseUrl, int position, String url, Class<T> bean, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 6666666666666666666666666666666666");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxGet(url), new RxRequestResult<>(position, bean, getView()), position);
    }


    /**
     * post请求
     *
     * @param position
     * @param url
     * @param bean
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void postData(int position, String url, Class<T> bean, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 77777777777777777777777777777777777777");
        }
        toSubscribe(getApi().rxPost(url), new RxRequestResult<>(position, bean, getView()), position);
    }


    /**
     * post请求
     *
     * @param position
     * @param url
     * @param bean
     * @param objectMap
     * @param isShow    是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void postData(int position, String url, Class<T> bean, Map<String, Object> objectMap, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 8888888888888888888888888888888888888888");
        }
        toSubscribe(getApi().rxPost(url, objectMap), new RxRequestResult<>(position, bean, getView()), position);
    }

    /**
     * post请求
     *
     * @param position
     * @param url
     * @param bean
     * @param objectMap
     * @param isShow    是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void postData(String baseUrl, int position, String url, Class<T> bean, Map<String, Object> objectMap, Map<String, Object> headMap, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 99999999999999999999999999999999999999999");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxPost(url, objectMap, headMap), new RxRequestResult<>(position, bean, getView()), position);
    }

    /**
     * * post请求
     *
     * @param baseUrl
     * @param position
     * @param url
     * @param bean
     * @param headMap
     * @param isShow
     * @param <T>
     */

    public <T extends BaseBean> void postHead(String baseUrl, int position, String url, Class<T> bean, Map<String, Object> headMap, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 99999999999999999999999999999999999999999");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxPost2(url, headMap), new RxRequestResult<>(position, bean, getView()), position);
    }


    /**
     * post请求 加json数据
     *
     * @param position
     * @param url
     * @param bean
     * @param objectMap
     * @param isShow    是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void postBodyData(int position, String url, Class<T> baseBean, Map<String, Object> objectMap, Class<?> bean, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 1010101010101010101010101010101010");
        }
        toSubscribe(getApi().rxPostBody(url, objectMap, bean), new RxRequestResult<>(position, baseBean, getView()), position);
    }

    /**
     * post请求 加json数据
     *
     * @param position
     * @param url
     * @param bean
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void postBodyData(int position, String url, Class<T> baseBean, Object bean, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 121212121212112121212121212121121212");
        }
        toSubscribe(getApi().rxPostBody(url, bean), new RxRequestResult<>(position, baseBean, getView()), position);
    }

    /**
     * post请求 加json数据
     *
     * @param position
     * @param url
     * @param bean
     * @param isShow   是否需要弹窗
     * @param mapHead  是否需要弹窗添加请求头
     * @param <T>
     */
    public <T extends BaseBean> void postBodyData(int position, String url, Class<T> baseBean, Object bean, Map<String, Object> mapHead, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 131313131313131313131313131313");
        }
        toSubscribe(getApi().rxPostBody(url, bean, mapHead), new RxRequestResult<>(position, baseBean, getView()), position);
    }


    /**
     * post请求 加json数据
     *
     * @param position
     * @param url
     * @param bean
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void postBodyData(String baseUrl, int position, String url, Class<T> baseBean, Object bean, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 141414141414141414141414141414141414");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxPostBody(url, bean), new RxRequestResult<>(position, baseBean, getView()), position);
    }

    /**
     * post请求 加json数据
     *
     * @param position
     * @param url
     * @param bean
     * @param isShow   是否需要弹窗
     * @param mapHead  是否需要弹窗添加请求头
     * @param <T>
     */
    public <T extends BaseBean> void postBodyData(String baseUrl, int position, String url, Class<T> baseBean, Object bean, Map<String, Object> mapHead, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 15151515151515151515151515151515");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxPostBody(url, bean, mapHead), new RxRequestResult<>(position, baseBean, getView()), position);
    }


    public <T extends BaseBean> void postBodyData2(String baseUrl, String url, Object bean, Map<String, Object> mapHead) {
        toSubscribe(createService(HttpApi.class, baseUrl).rxPostBody(url, bean, mapHead), new RxRequestResult2<>(), 100);
    }

    /**
     * 自定义域名post请求 加json数据
     *
     * @param baseUrl  域名地址
     * @param position
     * @param url
     * @param bean
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void postBodyData(String baseUrl, int position, String url, Class<T> baseBean, Class<?> bean, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 16161616161616161616161616161616");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxPostBody(url, bean), new RxRequestResult<>(position, baseBean, getView()), position);
    }


    /**
     * 文件上传
     *
     * @param position
     * @param url
     * @param bean
     * @param part
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getUploadFile(int position, String url, Class<T> bean, MultipartBody.Part part, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 17171717171717171717171717");
        }
        toSubscribe(getApi().rxFileUpload(url, part), new RxRequestResult<>(position, bean, getView()), position);
    }


    /**
     * 文件上传
     *
     * @param position
     * @param url
     * @param bean
     * @param part
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getUploadFile(int position, String url, Class<T> bean, RequestBody body, MultipartBody.Part part, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 181818181818181818181818");
        }
        toSubscribe(getApi().rxFileUpload(url, body, part), new RxRequestResult<>(position, bean, getView()), position);
    }


    /**
     * 文件上传
     *
     * @param position
     * @param url
     * @param bean
     * @param part
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getUploadFile(String baseUrl, int position, String url, Class<T> bean, RequestBody body, MultipartBody.Part part, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 1919191919191919191919");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxFileUpload(url, body, part), new RxRequestResult<>(position, bean, getView()), position);
    }


    /**
     * 多张图片上传
     *
     * @param position
     * @param url
     * @param bean
     * @param part
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getUploadFiles(String baseUrl, int position, String url, Class<T> bean, RequestBody body, Map<String, RequestBody> part, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 20202020202020202020202020202020");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxFileUploads(url, body, part), new RxRequestResult<>(position, bean, getView()), position);
    }


    /**
     * 文件上传
     *
     * @param position
     * @param url
     * @param bean
     * @param part
     * @param isShow   是否需要弹窗
     * @param <T>
     */
    public <T extends BaseBean> void getUploadFile(String baseUrl, int position, String url, Class<T> bean, MultipartBody.Part part, boolean isShow) {
        if (isShow && getView() != null) {
            getView().onShowLoading();
            Log.i("mvppresentnnt", "getData: ---------- 2121212121212121212121212121212121");
        }
        toSubscribe(createService(HttpApi.class, baseUrl).rxFileUpload(url, part), new RxRequestResult<>(position, bean, getView()), position);
    }


}
