package com.xxfc.rv.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.share.utils.TransformationUtils;
import com.xxfc.rv.GuideActivity;
import com.xxfc.rv.MainActivity;
import com.xxfc.rv.R;

public class GuideFourthFragment extends BaseFragment<CommonPresenter> {
    private ImageView imageView;
    private TextView textView1;
    private TextView textView2;
    private Button btnConfirm;

    public GuideFourthFragment() {

    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_guide;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        imageView = getView().findViewById(R.id.image);
        textView1 = getView().findViewById(R.id.textview1);
        textView2 = getView().findViewById(R.id.textview2);
        btnConfirm = getView().findViewById(R.id.btn_confirm);
        btnConfirm.setVisibility(View.VISIBLE);
        btnConfirm.setOnClickListener(v -> {

            startActivity(MainActivity.getIntent(getContext()));
            mPresenter.getView().onShowLoading();
            new Thread(() -> {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                getActivity().finish();;
            }).start();
        });
        textView1.setText("开启房车自驾新旅程");
        String html = "出发即是家，开门即是景";
        textView2.setText(html);
        Glide.with(getActivity())
                .asBitmap()
                .load(R.drawable.icon_guide4)
                .into(new TransformationUtils(imageView));
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        mPresenter.getView().onHideLoading();
    }
}
