package com.xxrv.video.weight;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.danikula.videocache.HttpProxyCacheServer;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.base.BaseView;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;
import com.ruiwenliu.wrapper.presenter.WrapperPresenter;
import com.ruiwenliu.wrapper.util.glide.GlideApp;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.xxrv.video.R;
import com.xxrv.video.activity.TriListActivity;
import com.xxrv.video.api.VideoApi;
import com.xxrv.video.base.Proxy;
import com.xxrv.video.bean.circle.DiscoveryVideoBean;
import com.xxrv.video.bean.circle.VideoIMTokenBean;
import com.xxrv.video.dialog.TrillCommDialog;
import com.xxrv.video.presenter.VideoPresenter;
import com.xxrv.video.weight.likeView.LikeAnimationView;
import com.xxrv.video.weight.likeView.LikeRelativeLayout;
import com.yuyife.okgo.OkGoUtil;

import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

import fm.jiecao.jcvideoplayer_lib.JCVideoPlayer;
import fm.jiecao.jcvideoplayer_lib.JCVideoViewbyXuan;
import fm.jiecao.jcvideoplayer_lib.OnJcvdListener;
import okhttp3.Call;

public class JcvTrillVideo extends FrameLayout implements BaseView, View.OnClickListener {
    TriListActivity mShareListener;
    int position;
    private Context mContext;
    private boolean isPause;
    private boolean isPraise;
    private int mCommCount;
    private int mLikeCount;
    private long mVideoSize;
    private String mToken;
    private String videoUserid;
    private String mMessageid;
    private String sVideoUrl;
    private TextView titleTextView;
    private TextView tvlikesCount;
    private TextView tvCommCount;
    private TextView tvShare;
    private TextView tvPlay;
    private TextView tvBgName;
    private TextView tvName;
    private ImageView ivAvatar;
    private ImageView ivDisc;
    private ImageView startBtn;
    private ImageView thumbImageView;
    public Runnable HideThumbTask = new Runnable() {

        @Override
        public void run() {
            thumbImageView.setVisibility(GONE);
        }
    };
    private RelativeLayout rlDisc;
    private JCVideoViewbyXuan mVideoView;
    private Xpreprogressbar progressBar;
    private LikeRelativeLayout mLikeRelativeLayout;
    private LikeAnimationView btnLikes;
    private long mLastDoubleTapClickTime;
    private GestureDetector mGestureDetector;
    private Animation rotateAnim;
    private TrillCommDialog mCommDialog;
    private ProgressBar willPro;
    private VideoIMTokenBean ImTokenBean;

    private OnJcvdListener mVideoListener = new OnJcvdListener() {
        @Override
        public void onPrepared() {
            isPause = false;
//             thumbImageView.setVisibility(GONE);
            thumbImageView.postDelayed(HideThumbTask, 300);

            startBtn.setVisibility(GONE);
            rlDisc.startAnimation(rotateAnim);

            if (mVideoView.mCurrState == JCVideoPlayer.CURRENT_STATE_PAUSE) {
                progressBar.play(mVideoView.getDuration());
            } else {
                progressBar.play(0, mVideoView.getDuration());

            }
            willPro.setVisibility(GONE);
            Log.e("xuan", "onPrepared: " + mVideoView.mCurrState);
        }

        @Override
        public void onCompletion() {
            progressBar.clear();
            willPro.setVisibility(GONE);
        }

        @Override
        public void onError() {
            willPro.setVisibility(GONE);
            startBtn.setVisibility(VISIBLE);
            startBtn.setImageResource(R.drawable.jc_click_error_selector);
        }

        @Override
        public void onPause() {
            isPause = true;
            startBtn.setVisibility(VISIBLE);
            willPro.setVisibility(GONE);
            startBtn.setImageResource(R.drawable.ic_play_inco);
            progressBar.cancelProgressTimer();
            rlDisc.clearAnimation();
        }

        @Override
        public void onReset() {
            thumbImageView.setVisibility(VISIBLE);
            startBtn.setVisibility(GONE);
            willPro.setVisibility(VISIBLE);
            rlDisc.clearAnimation();
            progressBar.clear();
            progressBar.cancelProgressTimer();
        }
    };
    private VideoPresenter mPresenter;

    public JcvTrillVideo(Context context) {
        this(context, null);
    }

    public JcvTrillVideo(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JcvTrillVideo(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(@NonNull Context context) {
        ParameterizedType type = (ParameterizedType) context.getClass().getGenericSuperclass();
        Class<? extends WrapperPresenter> presenterClass = (Class<? extends WrapperPresenter>) type.getActualTypeArguments()[0];
        try {
            this.mPresenter = (VideoPresenter) presenterClass.newInstance();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        }
        mPresenter.attachView(this);

        View.inflate(context, R.layout.layout_jcv_trill, this);
        mContext = context;

        mLikeRelativeLayout = findViewById(R.id.like_relativeLayout);
        mVideoView = findViewById(R.id.xuan_video);
        thumbImageView = findViewById(R.id.thumb);
        startBtn = findViewById(R.id.start);
        willPro = findViewById(R.id.progress);


        tvName = findViewById(R.id.tv_name); // 用户名称
        titleTextView = findViewById(R.id.tv_title);
        tvBgName = findViewById(R.id.tv_bgname); // 背景音乐名称
        progressBar = findViewById(R.id.bottom_progress);

        ivAvatar = findViewById(R.id.iv_avatar);
        btnLikes = findViewById(R.id.iv_likes);
        tvlikesCount = findViewById(R.id.tv_likes);// 点赞数
        tvCommCount = findViewById(R.id.tv_comm);  // 评论数
        tvShare = findViewById(R.id.tv_share);  // 转发数
        tvPlay = findViewById(R.id.tv_play);  // 播放数
        ivDisc = findViewById(R.id.iv_disc); // 光盘图标
        rlDisc = findViewById(R.id.rl_disc); // 大光盘

        ivAvatar.setOnClickListener(this);
        btnLikes.setOnClickListener(this);// 点赞按钮
        findViewById(R.id.iv_follow).setOnClickListener(this);// 关注
        findViewById(R.id.iv_comm).setOnClickListener(this);  // 评论按钮
        findViewById(R.id.iv_share).setOnClickListener(this); // 分享按钮

        mVideoView.addOnJcvdListener(mVideoListener);
        initGestureAndAnimation(context);
    }

    private void initGestureAndAnimation(Context context) {
        mGestureDetector = new GestureDetector(context, new GestureDetector.SimpleOnGestureListener() {
            @Override
            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (System.currentTimeMillis() - mLastDoubleTapClickTime <= 600) {
                    /*
                    之前有一个bug，即当用户在双击点赞时，如点击屏幕的次数为单数，最后都会触发onSingleTapConfirmed事件
                    现加一个时间判断，如当前时间减去最后一次双击时间小于600ms，认定当前用户正在进行双击操作 做弹爱心处理
                     */
                    mLikeRelativeLayout.start(e);
                    return true;
                }
                if (isPause) {
                    mVideoView.play("");
                } else {
                    mVideoView.pause();
                }
                return true;
            }

            @Override
            public boolean onDoubleTap(MotionEvent e) {
                // 记录触发双击的时间
                mLastDoubleTapClickTime = System.currentTimeMillis();
                if (!isPraise) {// 非like状态，需要调用赞接口
                    loadImToken();
                }
                mLikeRelativeLayout.start(e);
                return true;
            }
        });

        rotateAnim = AnimationUtils.loadAnimation(context, R.anim.rotate_anim_disc);
        LinearInterpolator lin = new LinearInterpolator();
        rotateAnim.setInterpolator(lin);
        rotateAnim.setFillAfter(true);
    }

    public int getCurrState() {
        return mVideoView.mCurrState;
    }

    public void startVideo() {
        // 增加缓存
        HttpProxyCacheServer proxy = Proxy.getInstance().getProxy(mContext);
        mVideoView.play(proxy.getProxyUrl(sVideoUrl));
    }

    private String formatCount(int count) {
        if (count < 10000) {
            return String.valueOf(count);
        }
        return String.format(Locale.getDefault(), "%.1fw", count / 1000 / 10.0);
    }

    public void updateDatas(DiscoveryVideoBean.DataBeanX.DataBean bean, String token) {
        mToken = token;
        mMessageid = bean.getMsgId();

        sVideoUrl = bean.getFirstVideo();
        String iUrl = bean.getFirstImageOriginal();
        String text = bean.getBody().getText();

        GlideApp.with(mContext).load(iUrl).into(thumbImageView);

        videoUserid = bean.getUserId();
        GlideManager.getInstance(mContext).loadCircleImage(bean.getPicUrl(), ivAvatar);
        GlideManager.getInstance(mContext).loadCircleImage(bean.getPicUrl(), ivDisc);

        mVideoSize = bean.getFirstVideoSize();
        mCommCount = bean.getComments().size();
        mLikeCount = bean.getPraiseCount();
        tvCommCount.setText(formatCount(mCommCount));
        tvlikesCount.setText(formatCount(mLikeCount));
        tvShare.setText(formatCount(bean.getCount().getForward()));
        tvPlay.setText(formatCount(bean.getCount().getPlay()));

        mCommDialog = TrillCommDialog.getInstance();// 创建评论窗口
        mCommDialog.setOnUpdateCommListener(mContext, bean.getComments(), bean.getMsgId(), new TrillCommDialog.OnUpdateCommListener() {
            @Override
            public void updateCommCount() {
                mCommCount++;
                tvCommCount.setText(String.valueOf(mCommCount));
            }
        });

        isPraise = bean.getIsPraise() == 1;
        if (isPraise) {
            btnLikes.setLikeStatus(1);
        } else {
            btnLikes.setLikeStatus(0);
        }

        if (TextUtils.isEmpty(bean.getBody().getText())) {
            titleTextView.setVisibility(GONE);
        } else {
            titleTextView.setVisibility(VISIBLE);
            titleTextView.setText(bean.getBody().getText());
        }

        tvName.setText("@" + String.valueOf(bean.getNickname()));
        String str = "@" + bean.getNickname() + "原创音乐";
        tvBgName.setText(str + "             " + str + "               " + str);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        mGestureDetector.onTouchEvent(event);
        return true;
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();// 关注
        if (id == R.id.iv_avatar) {
            // 点击头像

        } else if (id == R.id.iv_follow) {
        } else if (id == R.id.iv_likes) {
            // 点赞按钮
            loadImToken();
        } else if (id == R.id.iv_comm) {
            // 评论按钮
            if (mContext instanceof BaseStatusActivity) {
                mCommDialog.show(((BaseStatusActivity) mContext).getSupportFragmentManager(), "TilTok");
            }
        } else if (id == R.id.iv_share) {
            // 分享按钮
            shareMessage();
        } else if (id == R.id.xuan_video) {
            // 暂停视频
            mVideoView.pause();
        }

    }

    private void loadImToken() {
        if (OkGoUtil.getToken() != null) {
            Map<String, Object> headMap = new LinkedHashMap<>();
            headMap.put("Authorization", OkGoUtil.getToken());
            mPresenter.postData(RvFrameConfig.HOST, 1, VideoApi.DISCOVERY_IM_LOGIN, VideoIMTokenBean.class, headMap, headMap, false);
        }
    }

    private void praiseOrCancel() {
        if (TextUtil.isEmpty(ImTokenBean.getData())) {
            return;
        }
        Map<String, String> params = new HashMap<>();
        params.put("access_token", ImTokenBean.getData());
        params.put("messageId", mMessageid);
        if (isPraise) {
            mPresenter.postData(2, VideoApi.DISCOVERY_PRAISE_DELETE, BaseBean.class, params, false);
        } else {
            mPresenter.postData(2, VideoApi.DISCOVERY_PRAISE_ADD, BaseBean.class, params, false);
        }
    }

    private void shareMessage() {

        if (mShareListener != null) {
//            mShareListener.onShare(mMessageid, sVideoUrl, mVideoSize, position);
        }
    }

    public void onShareListener(TriListActivity triListActivity) {
        mShareListener = triListActivity;
    }

    public void setPosiont(int position) {
        this.position = position;
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 1:
                ImTokenBean = (VideoIMTokenBean) result;
                praiseOrCancel();
                break;
            case 2:
                if (isPraise) {
                    btnLikes.cancel();
                } else {
                    btnLikes.start();
                }
                isPraise = !isPraise;
                if (isPraise) {
                    mLikeCount++;
                } else {
                    mLikeCount--;
                }
                tvlikesCount.setText(String.valueOf(mLikeCount));
                break;
        }
    }

    @Override
    public void onBeforeSuccess() {

    }

    @Override
    public void onShowLoading() {

    }

    @Override
    public void onHideLoading() {

    }

    @Override
    public void onShowError(String errorMsg, int errorType) {

    }

    @Override
    public void onErrorToken() {

    }
}
