package com.xxrv.video.base;

import android.content.Context;

import com.danikula.videocache.HttpProxyCacheServer;

public class Proxy {
    private static Proxy instance = null;

    public static <T> Proxy getInstance() {
        if (instance == null) {
            synchronized (Proxy.class) {
                if (instance == null) {
                    instance = new Proxy();
                }
            }

        }
        return instance;
    }

    // 抖音模块缓存
    private HttpProxyCacheServer proxy;

    public HttpProxyCacheServer getProxy(Context context) {
        return proxy == null ? (proxy = newProxy(context)) : proxy;
    }

    private HttpProxyCacheServer newProxy(Context context) {
        return new HttpProxyCacheServer.Builder(context)
                .maxCacheSize(1024 * 1024 * 1024)       // 1 Gb for cache
                .fileNameGenerator(new MyFileNameGenerator()).build();
    }


}
