package com.xxrv.video.adapter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.xxrv.video.R;
import com.xxrv.video.activity.TriListActivity;
import com.xxrv.video.bean.circle.DiscoveryVideoBean;
import com.xxrv.video.weight.JcvTrillVideo;

/**
 * 视频item
 */

public class ListVideoAdapter extends BaseQuickAdapter<DiscoveryVideoBean.DataBeanX.DataBean, BaseViewHolder> {
    private final TriListActivity triListActivity;
    private int mPosition;

    public ListVideoAdapter(TriListActivity triListActivity, int position) {
        super(R.layout.item_trill);
        this.triListActivity = triListActivity;
        mPosition = position;
    }

    @Override
    protected void convert(BaseViewHolder helper, DiscoveryVideoBean.DataBeanX.DataBean item) {
        ViewGroup.LayoutParams layoutParams = helper.itemView.getLayoutParams();
        layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT;
        JcvTrillVideo mp_video = helper.getView(R.id.mp_video);
        mp_video.updateDatas(item, "");
        mp_video.onShareListener(triListActivity);
        mp_video.setPosiont(helper.getPosition());
//        Log.e("xuan", "onHolder: " + position + " ,,  " + TriListActivity.this.position);
        if (helper.getPosition() == mPosition) {
            mp_video.startVideo();
        }
    }
}
