package com.xxrv.video.activity;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.xxrv.video.R;
import com.xxrv.video.R2;
import com.xxrv.video.adapter.DiscoveryVideoSelectAdapter;
import com.xxrv.video.bean.circle.VideoFile;
import com.xxrv.video.presenter.VideoPresenter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

/**
 * 视频选择
 */
public class SelectVideoActivity extends BaseStatusActivity<VideoPresenter> {


    @BindView(R2.id.rv_video_content)
    RecyclerView rvVideoContent;

    private DiscoveryVideoSelectAdapter selectAdapter;


    public static Intent getIntent(Context context) {
        return new Intent(context, SelectVideoActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_select_video;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("视频选择");

        selectAdapter = new DiscoveryVideoSelectAdapter();
        rvVideoContent.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        rvVideoContent.setNestedScrollingEnabled(false);
        rvVideoContent.setAdapter(selectAdapter);

        selectAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                VideoFile item = (VideoFile) adapter.getItem(position);
                getIntent().putExtra("videofile", item);
                setResult(201, getIntent());
                finish();
            }
        });

        selectAdapter.addData(videoInAlbum());
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    /**
     * 查系统相册中的视频，
     *
     * @return 查询失败返回null, 与空结果分开表示，
     */
    @Nullable
    private List<VideoFile> videoInAlbum() {
        String[] projection = new String[]{
                MediaStore.Video.Media.DATA,
                MediaStore.Video.Media.DATE_ADDED,
                MediaStore.Video.Media.SIZE,
                MediaStore.Video.Media.DURATION
        };
        // 只支持mp4, 据测flv可能被搜到并出现问题，
        String selection = MediaStore.Video.Media.MIME_TYPE + " = ?";
        String[] selectionArgs = new String[]{
                "video/mp4"
        };
        Cursor cursor = getContentResolver().query(
                MediaStore.Video.Media.EXTERNAL_CONTENT_URI,
                projection, selection, selectionArgs,
                MediaStore.Video.Media.DATE_ADDED + " DESC");
        if (cursor == null) {
            return null;
        }
        List<VideoFile> list = new ArrayList<>(cursor.getCount());
        while (cursor.moveToNext()) {
            String filePath = cursor.getString(cursor.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
            if (!new File(filePath).exists()) {
                // 系统相册数据库中可能没有及时同步，可能存在已经被删除了的视频的记录，
                continue;
            }
            Long createTime = cursor.getLong(cursor.getColumnIndexOrThrow(MediaStore.Video.Media.DATE_ADDED));
            Long fileSize = cursor.getLong(cursor.getColumnIndexOrThrow(MediaStore.Video.Media.SIZE));
            Long timeLen = cursor.getLong(cursor.getColumnIndexOrThrow(MediaStore.Video.Media.DURATION));
            if (timeLen == 0) {
                continue;
            }
            VideoFile videoFile = new VideoFile();
            // 系统相册查出来的时间单位是秒，这里要的是毫秒，所以乘以一千，
            videoFile.setCreateTime(1000 * createTime);
            // 系统相册查出来的时长单位是毫秒，这里要的是秒，所以除以一千，
            videoFile.setFileLength(timeLen / 1000);
            videoFile.setFileSize(fileSize);
            videoFile.setFilePath(filePath);
            list.add(videoFile);
        }
        cursor.close();
        return list;
    }
}
