package com.rv.im.view;

;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.rv.im.R;


/**
 * Created by root on 2018/9/12.
 */

public class CycleProgress extends View {
    private Context mContext;
    private int cycleBgStrokeWidth;
    private int progressStrokeWidth;
    private boolean isProgressText;
    private int centerTextColor;
    private int centerTextSize;
    private int cycleBgColor;
    private int progressColor;
    private Paint progressPaint;
    private Paint cycleBgPaint;
    private Paint centerTextPaint;
    /**
     * 圆心x坐标
     */
    private float centerX;
    /**
     * 圆心y坐标
     */
    private float centerY;
    /**
     * 圆的半径
     */
    private float radius;
    /**
     * 进度
     */
    private float mProgress = 0;


    /**
     * 扇形所在矩形
     */
    private RectF rectF = new RectF();

    public CycleProgress(Context context) {
        super(context);
        init(context, null);
    }

    public CycleProgress(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public CycleProgress(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        getAttr(attrs);  // 获取控件属性，
        initPaint(); // 初始化圆圈画笔
        initTextPaint(); // 初始化文字画笔
    }

    /**
     * 获取控件属性（命名空间）
     */
    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = mContext.obtainStyledAttributes(attrs, R.styleable.CycleProgress);
        cycleBgStrokeWidth = 10;
        progressStrokeWidth = 10;
        isProgressText = true;
        centerTextColor = Color.parseColor("#999999");
        centerTextSize = 30;
        cycleBgColor = Color.parseColor("#ffffff");
        progressColor = Color.parseColor("#66999999");

        typedArray.recycle();
    }

    /**
     * 初始化圆圈画笔
     */
    private void initPaint() {
        progressPaint = getPaint(progressStrokeWidth, progressColor);
        cycleBgPaint = getPaint(cycleBgStrokeWidth, cycleBgColor);
    }

    private Paint getPaint(int width, int color) {
        Paint paint = new Paint(Paint.ANTI_ALIAS_FLAG);
        paint.setStrokeWidth(width);
        // Paint.Style.FILL:填充内部  Paint.Style.FILL_AND_STROKE:填充内部和描边Paint.Style.STROKE :描边
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(color);
        paint.setAntiAlias(true); // 扛锯齿
        paint.setStrokeCap(Paint.Cap.ROUND); // 两端是圆角
        return paint;
    }

    /**
     * 初始化文字画笔
     */

    private void initTextPaint() {
        centerTextPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        centerTextPaint.setColor(centerTextColor);
        centerTextPaint.setTextAlign(Paint.Align.CENTER);  // 设置文字位置在中间
        centerTextPaint.setTextSize(centerTextSize);  // 设置文字大小
        centerTextPaint.setAntiAlias(true);
    }


    /**
     * view发生改变的时候调用
     *
     * @param w
     * @param h
     * @param oldw
     * @param oldh
     */
    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);

        centerX = w / 2;
        centerY = h / 2;
        radius = Math.min(w, h) / 2 - Math.max(cycleBgStrokeWidth, progressStrokeWidth); // 两数中的最小值 / 2 - 两数中的最大值

        rectF.set(centerX - radius, centerY - radius, centerX + radius, centerY + radius);
    }

    /**
     * 画
     *
     * @param canvas
     */
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle(centerX, centerY, radius, cycleBgPaint);
        canvas.drawArc(rectF, 270, mProgress * 3.6f, false, progressPaint);
        if (isProgressText) {
            Paint.FontMetrics fontMetrics = centerTextPaint.getFontMetrics();
            int baseline = (int) ((rectF.bottom + rectF.top - fontMetrics.bottom - fontMetrics.top) / 2);
            canvas.drawText((int) mProgress + "%", rectF.centerX(), baseline, centerTextPaint);
        }
    }

    public void setmProgress(int progress) {
        this.mProgress = progress;
        invalidate();
    }


}
