package com.rv.im.db.table;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.rv.im.enums.MessageTypeEnum;

import java.io.Serializable;

@DatabaseTable(tableName = "tb_conversation")
public class ChatConversation implements Serializable {

    @DatabaseField(columnName = "_id", dataType = DataType.INTEGER, generatedId = true)
    private int id;
    @DatabaseField(columnName = "userId")
    private String userId;
    @DatabaseField(columnName = "userName")
    private String userName;

    private long lastMessageTime;

    private int unReadMessage;

    private String lastMsg;

    private int state;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getLastMessageTime() {
        return lastMessageTime;
    }

    public void setLastMessageTime(long lastMessageTime) {
        this.lastMessageTime = lastMessageTime;
    }

    public int getUnReadMessage() {
        return unReadMessage;
    }

    public void setUnReadMessage(int unReadMessage) {
        this.unReadMessage = unReadMessage;
    }

    public String getLastMsg() {
        return lastMsg;
    }

    public void setLastMsg(String lastMsg) {
        this.lastMsg = lastMsg;
    }

    public void setLastMessageInfo(ChatMessage lastMessageInfo) {

        if (lastMessageInfo.getMessageType() == MessageTypeEnum.TEXT.getType()) {
            setLastMsg(lastMessageInfo.getContent());
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.PIC.getType()) {
            setLastMsg("[图片]");
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.FILE.getType()) {
            setLastMsg("[文件]");
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.VOICE.getType()) {
            setLastMsg("[语音]");
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.VOLTE_CALL.getType()) {
            setLastMsg("[语音通话]");
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.VIDEO_CALL.getType()) {
            setLastMsg("[视频]");
        }
        setLastMessageTime(lastMessageInfo.getTimeSend());
    }
}
