package com.rv.im.db.service;

import android.content.Context;

import com.rv.im.ImSetting;
import com.rv.im.db.dao.ConversationDao;
import com.rv.im.db.dao.MessageDao;
import com.rv.im.db.table.ChatConversation;
import com.rv.im.db.table.ChatMessage;

import java.util.List;

public class ChatMessageServiceImp implements IChatMessageService {

    private MessageDao dao = null;
    private static ChatMessageServiceImp instance = null;
    private ConversationDao conversationDao = null;

    private ChatMessageServiceImp(Context context) {
        dao = new MessageDao(context);
        conversationDao = ConversationDao.getInstance(context);
    }

    public static ChatMessageServiceImp getInstance(Context context) {
        if (instance == null) {
            instance = new ChatMessageServiceImp(context.getApplicationContext());
        }
        return instance;
    }


    @Override
    public List<ChatMessage> getAllMessage(String userId) {
        return dao.getAllChatMessageByConversation(userId);
    }

    @Override
    public void addMessage(ChatMessage message) {
        ChatConversation conversation = new ChatConversation();
        if (message != null) {
            conversation.setUserId(message.getFromUserId() == ImSetting.getUserId() ? message.getToUserId() : message.getFromUserId());
            conversation.setUserName(message.getFromUserId() == ImSetting.getUserId() ? message.getToUserName() : message.getFromUserName());
        }
        conversationDao.addConversation(conversation);
        dao.addMessage(message);
    }

    @Override
    public void setMsgSendSuccess(String receiptId) {
        dao.setMsgSuccess(receiptId);
    }

    @Override
    public void setUpProgress(String packId, int progress) {
        dao.setUpProgress(packId, progress);
    }

    @Override
    public void setUpFailure(String packId) {
        dao.setUpFailure(packId);
    }

    @Override
    public void setMsgSendFailure(String receiptId) {
        dao.setSendFailure(receiptId);
    }

    @Override
    public void setUpSuccess(String packId, String url) {
        dao.setUpSuccess(packId, url);
    }

    @Override
    public ChatMessage getLastMsg(String userId) {
        return dao.getLastMsgByUserId(userId);
    }

    @Override
    public int getUnReadMsg(String targetUserId) {
        return dao.getUnReadMessage(targetUserId);
    }

    @Override
    public int getUnReadMsg() {
        return dao.getUnReadMessage();
    }

    @Override
    public void setMsgRead(String targetUserId) {
        dao.setMessageRead(targetUserId);
    }

    @Override
    public void setVoicePlay(String packId) {
        dao.setVoicePlay(packId);
    }

    @Override
    public int getPages(String userId) {
        return dao.getPages(userId);
    }

    @Override
    public void deleteMessage(ChatMessage message) {
        dao.deleteMessage(message);
    }

    @Override
    public List<ChatMessage> loadMoreMessage(String userId, long time) {
        return dao.loadMoreMessage(userId, time);
    }

    @Override
    public List<ChatMessage> getFirstPageMessage(String userId) {
        return dao.getFirstPageMessage(userId);
    }

    public void release() {
        instance = null;
    }
}
