package com.rv.im.db.dao;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.rv.im.db.SQLiteHelper;
import com.rv.im.db.table.DownBean;
import com.rv.im.mucfile.DownManager;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author liuxuan
 * @time 2017-7-7 14:39:11
 * @des 数据库操作类，下载dao
 */

public class DownDao {

    private AtomicInteger mOpenCounter = new AtomicInteger();
    private SQLiteDatabase mDatabase;

    private volatile static DownDao instance;

    private Context mContext;

    public Dao<DownBean, Integer> dao;
//    private SQLiteHelper mHelper;

    private DownDao(Context context) {
        try {
            this.mContext = context;
//            mHelper = OpenHelperManager.getHelper(mContext, SQLiteHelper.class);
            dao = DaoManager.createDao(SQLiteHelper.getInstance(mContext).getConnectionSource(), DownBean.class);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

//    public static final DownDao getInstance(Context context) {
//        if (instance == null) {
//            synchronized (MessageDao.class) {
//                if (instance == null) {
//                    instance = new DownDao(context);
//                }
//            }
//        }
//        return instance;
//    }

    public static final DownDao getInstance(Context context) {
        return new DownDao(context);
    }

    public boolean insert(DownBean info) {
        try {
            dao.executeRaw("insert into tb_down(url,name,start,end,state) values(?,?,?,?,?)",
                    new String[]{info.url, info.name, "0", info.max + "", DownManager.STATE_UNDOWNLOAD + ""});
        } catch (Exception e) {
            return false;
        }
        return true;
    }


    public DownBean query(String url) {

        DownBean result = null;
        try {
            List<DownBean> lists = dao.queryForEq("url", url);
            if (lists != null && lists.size() > 0) {
                result = lists.get(0);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean update(DownBean bean) {
        try {
            return dao.update(bean) > 0 ? true : false;
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete(String fileUrl) {
        if (isExists(fileUrl)) {
            try {
                dao.deleteBuilder().where().eq("url", fileUrl);
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean isExists(String fileUrl) {
        try {
            List<DownBean> lists = dao.queryForEq("url", fileUrl);
            if (lists != null && lists.size() > 0) {
                return true;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}