package com.rv.im.db.dao;

import android.content.Context;
import android.util.Log;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.rv.im.db.SQLiteHelper;
import com.rv.im.db.table.Customer;
import com.rv.im.log.LogUtil;

import java.sql.SQLException;
import java.util.List;

public class CustomerDao {

    private static final String TAG = ConversationDao.class.getSimpleName();
    private static CustomerDao instance = null;
    public Dao<Customer, Integer> dao;
    //    private SQLiteHelper mHelper;
    private Context mContext;

    private CustomerDao(Context context) {
        try {
            this.mContext = context;
//            mHelper = OpenHelperManager.getHelper(mContext, SQLiteHelper.class);
            dao = DaoManager.createDao(SQLiteHelper.getInstance(context).getConnectionSource(), Customer.class);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

//    public static final CustomerDao getInstance(Context context) {
//        if (instance == null) {
//            synchronized (ConversationDao.class) {
//                if (instance == null) {
//                    instance = new CustomerDao(context);
//                }
//            }
//        }
//        return instance;
//    }

    public static final CustomerDao getInstance(Context context) {
//        if (instance == null) {
//            synchronized (ConversationDao.class) {
//                if (instance == null) {
//                    instance = new CustomerDao(context);
//                }
//            }
//        }
        return new CustomerDao(context);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        OpenHelperManager.releaseHelper();
    }

    public List<Customer> getAllCustomer() {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return null;
        }
        List<Customer> customers = null;
        try {
            customers = dao.queryForAll();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return customers;
    }


    /*******
     * 插入消息
     * @param customer
     */
    public void addCustomer(Customer customer) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return;
        }
        if (customer == null) {
            LogUtil.e(TAG, "conversation is null");
            return;
        }
        Log.d(TAG, customer.toString());
        if (isExit(customer)) {
            updateCustomer(customer);
            return;
        }
        try {
            int result = dao.create(customer);
            LogUtil.d(TAG, "插入结果 " + result);
        } catch (SQLException e) {
            e.printStackTrace();
            LogUtil.d(TAG, "插入失败 " + e.getMessage());
        }
    }


    /*******
     * 插入消息
     * @param customers
     */
    public void addCustomers(List<Customer> customers) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return;
        }
        if (customers == null || customers.size() == 0) {
            LogUtil.e(TAG, "conversation is null");
            return;
        }
        for (Customer customer : customers) {
            addCustomer(customer);
        }
    }

    /*****
     * 更新消息
     * @param customer
     */
    public void updateCustomer(Customer customer) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return;
        }
        if (customer == null) {
            LogUtil.e(TAG, "message is null");
            return;
        }
        try {
            dao.update(customer);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*******
     * 判断是否存在会话
     * @param customer
     * @return
     */
    public boolean isExit(Customer customer) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return false;
        }
        if (customer == null) {
            LogUtil.e(TAG, "customer is null");
            return false;
        }
        try {
            List<Customer> lists = dao.queryForEq("customerId", customer.getCustomerId());
            return lists == null ? false : lists.size() == 0 ? false : true;
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

}
