package com.rv.rvmine.traveler;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.ApiConfig;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;

import butterknife.OnClick;

/**
 * 关于我们
 */
public class AboutUsActivity extends BaseStatusActivity<CommonPresenter> {


    public static Intent getIntent(Context context) {
        return new Intent(context, AboutUsActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_about_us;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("关于我们");
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.rl_item_privacy_policy, R2.id.rl_item_customer_service})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.rl_item_privacy_policy) {
            ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                    .withString("title", "隐私政策")
                    .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                    .withInt("type", 19)
                    .navigation();
        } else if (id == R.id.rl_item_customer_service) {
            Intent intent = new Intent(Intent.ACTION_DIAL);
            Uri uri = Uri.parse("tel:" + "4000369369");
            intent.setData(uri);
            startActivity(intent);
        }
    }
}
