package com.rv.rvmine.adapter;

import android.text.TextUtils;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.ruiwenliu.wrapper.util.TransformationUtil;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.rv.rvmine.R;
import com.rv.rvmine.bean.MyReleaseBean;

import java.util.ArrayList;
import java.util.List;

/**
 * 短视频
 */
public class MyReleaseVideoAdapter extends BaseQuickAdapter<MyReleaseBean.DataBeanX.DataBean, BaseGlideHolder> {

    private boolean isShowDelete = false; // 默认不显示选择框

    private List<MyReleaseBean.DataBeanX.DataBean> lists = new ArrayList<>(); // 选中

    public MyReleaseVideoAdapter() {
        super(R.layout.rv_item_rv_release_video);
    }

    public void changeBeanStatus(MyReleaseBean.DataBeanX.DataBean bean) {
        if (lists.contains(bean)) {
            lists.remove(bean);
        } else {
            lists.add(bean);
        }
    }

    public void removeSelect(MyReleaseBean.DataBeanX.DataBean bean) {
        if (lists.contains(bean)) lists.remove(bean);
    }

    public List<MyReleaseBean.DataBeanX.DataBean> getSelectLists() {
        return lists;
    }

    public void clear() {
        lists.clear();
    }

    public void changeViewShowState(boolean b) {
        this.isShowDelete = b;
        notifyDataSetChanged();
    }

    @Override
    protected void convert(BaseGlideHolder helper, MyReleaseBean.DataBeanX.DataBean item) {
        MyReleaseBean.DataBeanX.DataBean.Body body = item.getBody();
        if (body != null) {
            if (body.getVideos() != null && body.getVideos().size() > 0) {

//                GlideManager.getInstance(mContext).loadRoundImage2(body.getImages().get(0).getOurl(), (ImageView) helper.getView(R.id.iv_icon_pat),8);
                ImageView image = helper.getView(R.id.iv_icon_pat);
                if (!TextUtils.isEmpty(body.getVideos().get(0).getOurl()) && !body.getVideos().get(0).getOurl().equals(image.getTag())) {
                    image.setTag(null);//需要清
                    GlideOptions options = GlideOptions.placeholderOf(com.ruiwenliu.wrapper.R.drawable.glide_icon_placeholder).
                            error(com.ruiwenliu.wrapper.R.drawable.glide_icon_error);
                    TransformationUtil utils = new TransformationUtil(image);
                    Glide.with(mContext)
                            .asBitmap()
                            .load(body.getVideos().get(0).getOurl())
                            .apply(options)
                            .apply(RequestOptions.bitmapTransform(new RoundedCorners(12)).override(image.getWidth(), image.getHeight()))
                            .into(utils);
                    image.setTag(body.getVideos().get(0).getOurl());
                }
            }

            helper.setText(R.id.tv_title, body.getText());
//            helper.setText(R.id.tv_address, body);
            if ("4".equals(body.getType())) { //消息类型 基础属性 1=文字消息、2=图文消息、3=语音消息、4=视频消息、 5=文件消
                helper.setGone(R.id.iv_isvideo, true);
            } else {
                helper.setGone(R.id.iv_isvideo, false);
            }

            if (isShowDelete) {
                helper.setVisible(R.id.rl_delete_select, true);
            } else {
                helper.setVisible(R.id.rl_delete_select, false);
            }

            if (lists.contains(item)) {
                helper.setVisible(R.id.iv_delete_select, true);
            } else {
                helper.setVisible(R.id.iv_delete_select, false);
            }

            helper.addOnLongClickListener(R.id.ll_item_rv_enthusiast);
        }
    }
}
