package com.rv.rvmine.adapter;

import android.text.TextUtils;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.ruiwenliu.wrapper.util.TransformationUtil;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.rv.rvmine.R;
import com.rv.rvmine.bean.MyReleaseAskBean;
import com.rv.rvmine.bean.MyReleaseBean;

import java.util.ArrayList;
import java.util.List;

public class MyReleaseAskAdapter extends BaseQuickAdapter<MyReleaseAskBean.DataBean, BaseGlideHolder> {

    private boolean isShowDelete = false; // 默认不显示选择框

    private List<MyReleaseAskBean.DataBean> lists = new ArrayList<>(); // 选中


    public void changeBeanStatus(MyReleaseAskBean.DataBean bean) {
        if (lists.contains(bean)) {
            lists.remove(bean);
        } else {
            lists.add(bean);
        }
    }

    public void removeSelect(MyReleaseAskBean.DataBean bean) {
        if (lists.contains(bean)) lists.remove(bean);
    }

    public List<MyReleaseAskBean.DataBean> getSelectLists() {
        return lists;
    }

    public void clear() {
        lists.clear();
    }

    public MyReleaseAskAdapter() {
        super(R.layout.rv_item_rv_release_pat);
    }

    public void changeViewShowState(boolean b) {
        this.isShowDelete = b;
        notifyDataSetChanged();
    }

    @Override
    protected void convert(BaseGlideHolder helper, MyReleaseAskBean.DataBean item) {
        if (item != null) {
            if (!TextUtils.isEmpty(item.getTitle()))
                helper.setText(R.id.tv_title, item.getTitle());
            helper.setGone(R.id.iv_isvideo, false);
            if (isShowDelete) {
                helper.setVisible(R.id.rl_delete_select, true);
            } else {
                helper.setVisible(R.id.rl_delete_select, false);
            }

            if (lists.contains(item)) {
                helper.setVisible(R.id.iv_delete_select, true);
            } else {
                helper.setVisible(R.id.iv_delete_select, false);
            }

            helper.addOnLongClickListener(R.id.ll_item_rv_enthusiast);

            helper.addOnClickListener(R.id.rl_delete_select);
        }
    }
}
