package com.xxfc.discovery.adapter;

import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.TransformationUtil;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.xxfc.discovery.R;
import com.xxrv.video.bean.circle.DiscoveryVideoBean;

/**
 * 短视频
 */

public class DiscoveryShortVideoAdapter extends BaseQuickAdapter<DiscoveryVideoBean.DataBeanX.DataBean, BaseViewHolder> {

    public DiscoveryShortVideoAdapter() {
        super(R.layout.rv_item_discovery_short_video);
    }


    @Override
    protected void convert(BaseViewHolder helper, DiscoveryVideoBean.DataBeanX.DataBean item) {
        if (item == null) {
            return;
        }

        DiscoveryVideoBean.DataBeanX.DataBean.Body body = item.getBody();
        if (body != null) {
            if (body.getVideos() != null && body.getVideos().size() > 0) {

                ImageView image = helper.getView(R.id.iv_icon_video);
                GlideOptions options = GlideOptions.placeholderOf(com.ruiwenliu.wrapper.R.drawable.glide_icon_placeholder).
                        error(com.ruiwenliu.wrapper.R.drawable.glide_icon_error);
                TransformationUtil utils = new TransformationUtil(image);
                Glide.with(mContext)
                        .setDefaultRequestOptions(
                                new RequestOptions()
                                        .frame(1000000)
                                        .centerCrop()
                        )
                        .asBitmap()
                        .load(body.getVideos().get(0).getOurl())
                        .apply(options)
                        .apply(RequestOptions.bitmapTransform(new RoundedCorners(12)).override(image.getWidth(), image.getHeight()))
                        .into(utils);
            }
            helper.setText(R.id.tv_title, body.getText());
            if ("4".equals(body.getType())) { //消息类型 基础属性 1=文字消息、2=图文消息、3=语音消息、4=视频消息、 5=文件消
                helper.setGone(R.id.iv_isvideo, true);
            } else {
                helper.setGone(R.id.iv_isvideo, false);
            }
        }
        helper.setText(R.id.tv_user_name, item.getNickname());
        GlideManager.getInstance(mContext).loadImage(item.getPicUrl(), (ImageView) helper.getView(R.id.iv_user_icon));
        if (item.getCount() != null) {
            helper.setText(R.id.iv_like_number, "点赞数  " + item.getCount().getPraise());
        }
        if (1 == item.getIsPraise()) { //0：未点赞 1：已点赞
            helper.setTextColor(R.id.iv_like_number, mContext.getResources().getColor(R.color.gray_FFB74B));
        } else {
            helper.setTextColor(R.id.iv_like_number, mContext.getResources().getColor(R.color.textGray));
        }
    }
}
