package com.xxfc.discovery.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.xxfc.discovery.R;
import com.xxfc.discovery.bean.DiscoveryAskBean;

/**
 *  问答
 */

public class DiscoveryAskAdapter extends BaseQuickAdapter<DiscoveryAskBean.DataBeanX.DataBean, BaseViewHolder> {

    public DiscoveryAskAdapter() {
        super(R.layout.rv_item_discovery_ask);
    }

    private int selectPosition;

    @Override
    protected void convert(BaseViewHolder helper, DiscoveryAskBean.DataBeanX.DataBean item) {
        if (item ==null){
            return;
        }
        GlideManager.getInstance(mContext).loadImage(item.getPicUrl(),  (ImageView)helper.getView(R.id.iv_ask_icon));
          helper.setText(R.id.tv_ask_content,item.getTitle());
          helper.setText(R.id.tv_ask_name,item.getNickname());
          helper.setText(R.id.tv_like_number,item.getPraiseCount());
          helper.setText(R.id.tv_comment_number,item.getCommentCount());

          if (item.isPraise()){
                helper.setImageResource(R.id.iv_like,R.drawable.icon_discovery_ask_like);
          }else {
              helper.setImageResource(R.id.iv_like,R.drawable.icon_discovery_ask_unlike);
          }

          helper.addOnClickListener(R.id.ll_item_like);

    }
}
