package com.rv.component.utils;

import android.content.Context;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import android.widget.TextView;

/**
 * dp、sp 转换为 px 的工具类
 */
public class DisplayUtil {

    // 声音最长可以表现为多少毫秒（实际本程序是60s,但是如果这里是60s的话，当时间很短，就没啥差别
    public static final float voice_max_length = 30;
    public static final int voice_view_max_width = 145;// dp
    public static final int voice_view_min_width = 40;// dp
    /**
     * 将px值转换为dip或dp值，保证尺寸大小不变
     *
     * @param pxValue
     * @return
     */
    public static int px2dip(Context context, float pxValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }

    /**
     * 将dip或dp值转换为px值，保证尺寸大小不变
     *
     * @param dipValue
     * @return
     */
    public static int dip2px(Context context, float dipValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dipValue * scale + 0.5f);
    }

    public static float dpToPx(Context context, float dp){
        return TypedValue.applyDimension(
                TypedValue.COMPLEX_UNIT_DIP, dp, context.getResources().getDisplayMetrics());
    }


    /**
     * 将px值转换为sp值，保证文字大小不变
     *
     * @param pxValue
     * @return
     */
    public static int px2sp(Context context, float pxValue) {
        final float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int) (pxValue / fontScale + 0.5f);
    }

    /**
     * 将sp值转换为px值，保证文字大小不变
     *
     * @param spValue
     * @return
     */
    public static int sp2px(Context context, float spValue) {
        final float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int) (spValue * fontScale + 0.5f);
    }

    public static int getWidth(Context context) {
        WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        display.getMetrics(dm);
        return dm.widthPixels;

    }

    public static int getHeight(Context context) {
        WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        display.getMetrics(dm);
        return dm.heightPixels;

    }

    public static void backgroundAlpha(android.app.Activity a, float bgAlpha) {
        WindowManager.LayoutParams lp = a.getWindow().getAttributes();
        lp.alpha = bgAlpha; // 0.0-1.0
        a.getWindow().setAttributes(lp);
    }

    /**
     * 计算出该TextView中文字的宽度(像素)
     *
     * @param textView
     * @param text
     * @return
     */
    public static int getTextViewWidth(Context context, TextView textView, String text) {
        int px = 0;
        try {
            TextPaint paint = textView.getPaint();
            // 得到使用该paint写上text的时候,像素为多少
            float textLength = paint.measureText(text);
            px =(int)textLength;// dip2px(context, textLength);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return px;
    }


    public static int getVoiceViewWidth(Context context, int seconds) {
        if (seconds >= voice_max_length) {
            return dip2px(context, voice_view_max_width);
        }
        final int dpLen = (int) ((seconds / voice_max_length) * (voice_view_max_width - voice_view_min_width)) + voice_view_min_width;
        return dip2px(context, dpLen);
    }
}
